/* Copyright (C) 1998 Ben Pfaff <pfaffben@pilot.msu.edu>.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.                   
 
   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of         
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU  
   General Public License for more details.                           
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
   02111-1307, USA. */
#include "available-stubs.h"

#include <readline/history.h>
#include "checker_api.h"

#define M_C_FUN_LB_ET 44 /* FIXME.  */

/* compiled from: . */
#ifdef HAVE_using_history
/* From `/usr/include/readline/history.h:55'.  */
void chkr_stub_using_history (void ) __asm__ (CHKR_PREFIX ("using_history"));
void
chkr_stub_using_history (void )
{
#if USE_BI_JUMP
  __builtin_jump (using_history);
#else
  using_history ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_using_history */

#ifdef HAVE_history_get_history_state
/* From `/usr/include/readline/history.h:58'.  */
HISTORY_STATE * chkr_stub_history_get_history_state (void ) __asm__ (CHKR_PREFIX ("history_get_history_state"));
HISTORY_STATE *
chkr_stub_history_get_history_state (void )
{
  HISTORY_STATE * res;

  res = history_get_history_state ();
  if (res)
    stubs_chkr_set_right (res, sizeof (*res), CHKR_RW);
  return res;
}
#endif /* HAVE_history_get_history_state */

#ifdef HAVE_history_set_history_state
/* From `/usr/include/readline/history.h:61'.  */
void chkr_stub_history_set_history_state (HISTORY_STATE * arg0) __asm__ (CHKR_PREFIX ("history_set_history_state"));
void
chkr_stub_history_set_history_state (HISTORY_STATE * arg0)
{
  stubs_chkr_check_addr (arg0, sizeof (HISTORY_STATE), CHKR_RO, "state");
  history_set_history_state (arg0);
}
#endif /* HAVE_history_set_history_state */

#ifdef HAVE_add_history
/* From `/usr/include/readline/history.h:67'.  */
void chkr_stub_add_history (char * arg0) __asm__ (CHKR_PREFIX ("add_history"));
void
chkr_stub_add_history (char * arg0)
{
  stubs_chkr_check_str (arg0, CHKR_RO, "string");
#if USE_BI_JUMP
  __builtin_jump (add_history);
#else
  add_history (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_add_history */

#ifdef HAVE_remove_history
/* From `/usr/include/readline/history.h:72'.  */
HIST_ENTRY * chkr_stub_remove_history (int arg0) __asm__ (CHKR_PREFIX ("remove_history"));
HIST_ENTRY *
chkr_stub_remove_history (int arg0)
{
  HIST_ENTRY * res;
  res = remove_history (arg0);
  if (res)
    stubs_chkr_set_right (res, sizeof (*res), CHKR_RW);
  return res;
}
#endif /* HAVE_remove_history */

#ifdef HAVE_replace_history_entry
/* From `/usr/include/readline/history.h:77'.  */
HIST_ENTRY * chkr_stub_replace_history_entry (int arg0, char * arg1, char * arg2) __asm__ (CHKR_PREFIX ("replace_history_entry"));
HIST_ENTRY *
chkr_stub_replace_history_entry (int arg0, char * arg1, char * arg2)
{
  HIST_ENTRY * res;
  stubs_chkr_check_str (arg1, CHKR_RO, "line");
  res = replace_history_entry (arg0, arg1, arg2);
  if (res)
    stubs_chkr_set_right (res, sizeof (*res), CHKR_RW);
  return res;
}
#endif /* HAVE_replace_history_entry */

#ifdef HAVE_clear_history
/* From `/usr/include/readline/history.h:80'.  */
void chkr_stub_clear_history (void ) __asm__ (CHKR_PREFIX ("clear_history"));
void
chkr_stub_clear_history (void )
{
#if USE_BI_JUMP
  __builtin_jump (clear_history);
#else
  clear_history ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_clear_history */

#ifdef HAVE_stifle_history
/* From `/usr/include/readline/history.h:83'.  */
void chkr_stub_stifle_history (int arg0) __asm__ (CHKR_PREFIX ("stifle_history"));
void
chkr_stub_stifle_history (int arg0)
{
#if USE_BI_JUMP
  __builtin_jump (stifle_history);
#else
  stifle_history (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_stifle_history */

#ifdef HAVE_unstifle_history
/* From `/usr/include/readline/history.h:88'.  */
int chkr_stub_unstifle_history (void ) __asm__ (CHKR_PREFIX ("unstifle_history"));
int
chkr_stub_unstifle_history (void )
{
#if USE_BI_JUMP
  __builtin_jump (unstifle_history);
#else
  return unstifle_history ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_unstifle_history */

#ifdef HAVE_history_is_stifled
/* From `/usr/include/readline/history.h:91'.  */
int chkr_stub_history_is_stifled (void ) __asm__ (CHKR_PREFIX ("history_is_stifled"));
int
chkr_stub_history_is_stifled (void )
{
#if USE_BI_JUMP
  __builtin_jump (history_is_stifled);
#else
  return history_is_stifled ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_history_is_stifled */

#ifdef HAVE_history_list
/* From `/usr/include/readline/history.h:98'.  */
HIST_ENTRY ** chkr_stub_history_list (void ) __asm__ (CHKR_PREFIX ("history_list"));
HIST_ENTRY **
chkr_stub_history_list (void )
{
  HIST_ENTRY ** res;
  res = history_list ();
  if (res)
    {
      HIST_ENTRY **iter;

      for (iter = res; ; iter++)
	{
	  stubs_chkr_set_right (iter, sizeof (HIST_ENTRY *), CHKR_RW);
	  if (*res)
	    stubs_chkr_set_right (*iter, sizeof (HIST_ENTRY), CHKR_RW);
	  else
	    break;
	}
    }
  return res;
}
#endif /* HAVE_history_list */

#ifdef HAVE_where_history
/* From `/usr/include/readline/history.h:102'.  */
int chkr_stub_where_history (void ) __asm__ (CHKR_PREFIX ("where_history"));
int
chkr_stub_where_history (void )
{
#if USE_BI_JUMP
  __builtin_jump (where_history);
#else
  return where_history ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_where_history */

#ifdef HAVE_current_history
/* From `/usr/include/readline/history.h:106'.  */
HIST_ENTRY * chkr_stub_current_history (void ) __asm__ (CHKR_PREFIX ("current_history"));
HIST_ENTRY *
chkr_stub_current_history (void )
{
  HIST_ENTRY * res;
  res = current_history ();
  if (res)
    stubs_chkr_set_right (res, sizeof (*res), CHKR_RW);
  return res;
}
#endif /* HAVE_current_history */

#ifdef HAVE_history_get
/* From `/usr/include/readline/history.h:110'.  */
HIST_ENTRY * chkr_stub_history_get (int arg0) __asm__ (CHKR_PREFIX ("history_get"));
HIST_ENTRY *
chkr_stub_history_get (int arg0)
{
  HIST_ENTRY * res;
  res = history_get (arg0);
  if (res)
    stubs_chkr_set_right (res, sizeof (*res), CHKR_RW);
  return res;
}
#endif /* HAVE_history_get */

#ifdef HAVE_history_total_bytes
/* From `/usr/include/readline/history.h:114'.  */
int chkr_stub_history_total_bytes (void ) __asm__ (CHKR_PREFIX ("history_total_bytes"));
int
chkr_stub_history_total_bytes (void )
{
#if USE_BI_JUMP
  __builtin_jump (history_total_bytes);
#else
  return history_total_bytes ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_history_total_bytes */

#ifdef HAVE_history_set_pos
/* From `/usr/include/readline/history.h:119'.  */
int chkr_stub_history_set_pos (int arg0) __asm__ (CHKR_PREFIX ("history_set_pos"));
int
chkr_stub_history_set_pos (int arg0)
{
#if USE_BI_JUMP
  __builtin_jump (history_set_pos);
#else
  return history_set_pos (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_history_set_pos */

#ifdef HAVE_previous_history
/* From `/usr/include/readline/history.h:124'.  */
HIST_ENTRY * chkr_stub_previous_history (void ) __asm__ (CHKR_PREFIX ("previous_history"));
HIST_ENTRY *
chkr_stub_previous_history (void )
{
  HIST_ENTRY * res;
  res = previous_history ();
  if (res)
    stubs_chkr_set_right (res, sizeof (*res), CHKR_RW);
  return res;
}
#endif /* HAVE_previous_history */

#ifdef HAVE_next_history
/* From `/usr/include/readline/history.h:129'.  */
HIST_ENTRY * chkr_stub_next_history (void ) __asm__ (CHKR_PREFIX ("next_history"));
HIST_ENTRY *
chkr_stub_next_history (void )
{
  HIST_ENTRY * res;
  res = next_history ();
  if (res)
    stubs_chkr_set_right (res, sizeof (*res), CHKR_RW);
  return res;
}
#endif /* HAVE_next_history */

#ifdef HAVE_history_search
/* From `/usr/include/readline/history.h:139'.  */
int chkr_stub_history_search (char * arg0, int arg1) __asm__ (CHKR_PREFIX ("history_search"));
int
chkr_stub_history_search (char * arg0, int arg1)
{
  stubs_chkr_check_str (arg0, CHKR_RO, "string");
#if USE_BI_JUMP
  __builtin_jump (history_search);
#else
  return history_search (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_history_search */

#ifdef HAVE_history_search_prefix
/* From `/usr/include/readline/history.h:143'.  */
int chkr_stub_history_search_prefix (char * arg0, int arg1) __asm__ (CHKR_PREFIX ("history_search_prefix"));
int
chkr_stub_history_search_prefix (char * arg0, int arg1)
{
  stubs_chkr_check_str (arg0, CHKR_RO, "string");
#if USE_BI_JUMP
  __builtin_jump (history_search_prefix);
#else
  return history_search_prefix (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_history_search_prefix */

#ifdef HAVE_history_search_pos
/* From `/usr/include/readline/history.h:150'.  */
int chkr_stub_history_search_pos (char * arg0, int arg1, int arg2) __asm__ (CHKR_PREFIX ("history_search_pos"));
int
chkr_stub_history_search_pos (char * arg0, int arg1, int arg2)
{
  stubs_chkr_check_str (arg0, CHKR_RO, "string");
#if USE_BI_JUMP
  __builtin_jump (history_search_pos);
#else
  return history_search_pos (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_history_search_pos */

#ifdef HAVE_read_history
/* From `/usr/include/readline/history.h:157'.  */
int chkr_stub_read_history (char * arg0) __asm__ (CHKR_PREFIX ("read_history"));
int
chkr_stub_read_history (char * arg0)
{
#if USE_BI_JUMP
  __builtin_jump (read_history);
#else
  return read_history (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_read_history */

#ifdef HAVE_read_history_range
/* From `/usr/include/readline/history.h:164'.  */
int chkr_stub_read_history_range (char * arg0, int arg1, int arg2) __asm__ (CHKR_PREFIX ("read_history_range"));
int
chkr_stub_read_history_range (char * arg0, int arg1, int arg2)
{
  stubs_chkr_check_str (arg0, CHKR_RO, "filename");
#if USE_BI_JUMP
  __builtin_jump (read_history_range);
#else
  return read_history_range (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_read_history_range */

#ifdef HAVE_write_history
/* From `/usr/include/readline/history.h:169'.  */
int chkr_stub_write_history (char * arg0) __asm__ (CHKR_PREFIX ("write_history"));
int
chkr_stub_write_history (char * arg0)
{
  stubs_chkr_check_str (arg0, CHKR_RO, "filename");
#if USE_BI_JUMP
  __builtin_jump (write_history);
#else
  return write_history (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_write_history */

#ifdef HAVE_append_history
/* From `/usr/include/readline/history.h:173'.  */
int chkr_stub_append_history (int arg0, char * arg1) __asm__ (CHKR_PREFIX ("append_history"));
int
chkr_stub_append_history (int arg0, char * arg1)
{
  stubs_chkr_check_str (arg1, CHKR_RO, "filename");
#if USE_BI_JUMP
  __builtin_jump (append_history);
#else
  return append_history (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_append_history */

#ifdef HAVE_history_truncate_file
/* From `/usr/include/readline/history.h:176'.  */
int chkr_stub_history_truncate_file (char * arg0, int arg1) __asm__ (CHKR_PREFIX ("history_truncate_file"));
int
chkr_stub_history_truncate_file (char * arg0, int arg1)
{
  stubs_chkr_check_str (arg0, CHKR_RO, "filename");
#if USE_BI_JUMP
  __builtin_jump (history_truncate_file);
#else
  return history_truncate_file (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_history_truncate_file */

#ifdef HAVE_history_expand
/* From `/usr/include/readline/history.h:192'.  */
int chkr_stub_history_expand (char * arg0, char ** arg1) __asm__ (CHKR_PREFIX ("history_expand"));
int
chkr_stub_history_expand (char * arg0, char ** arg1)
{
  int res;
    
  stubs_chkr_check_str (arg0, CHKR_RO, "string");
  stubs_chkr_check_addr (arg1, sizeof (char *), CHKR_WO, "output");
  res = history_expand (arg0, arg1);
  stubs_chkr_set_right (*arg1, strlen (*arg1) + 1, CHKR_RW);
  return res;
}
#endif /* HAVE_history_expand */

#ifdef HAVE_history_arg_extract
/* From `/usr/include/readline/history.h:197'.  */
char * chkr_stub_history_arg_extract (int arg0, int arg1, char * arg2) __asm__ (CHKR_PREFIX ("history_arg_extract"));
char *
chkr_stub_history_arg_extract (int arg0, int arg1, char * arg2)
{
  char * res;

  stubs_chkr_check_str (arg2, CHKR_RO, "string");
  res = history_arg_extract (arg0, arg1, arg2);
  if (res)
    stubs_chkr_set_right (res, strlen (res) + 1, CHKR_RW);
  return res;
}
#endif /* HAVE_history_arg_extract */

#ifdef HAVE_get_history_event
/* From `/usr/include/readline/history.h:201'.  */
char * chkr_stub_get_history_event (char * arg0, int * arg1, int arg2) __asm__ (CHKR_PREFIX ("get_history_event"));
char *
chkr_stub_get_history_event (char * arg0, int * arg1, int arg2)
{
  stubs_chkr_check_str (arg0, CHKR_RO, "string");
  stubs_chkr_check_addr (arg1, sizeof (int), CHKR_RO, "cindex");
  if (*arg1 > strlen (arg0) + 1)
    {
      chkr_header ("Error in chkr_stub_get_history_event()");
      chkr_printf ("*cindex > strlen (string) + 1: *cindex=%d, strlen (string)=%d\n", *arg1, strlen (arg0));
    }
  {
    char * res;
    res = get_history_event (arg0, arg1, arg2);
    return res;
  }
}
#endif /* HAVE_get_history_event */

#ifdef HAVE_history_tokenize
/* From `/usr/include/readline/history.h:205'.  */
char ** chkr_stub_history_tokenize (char * arg0) __asm__ (CHKR_PREFIX ("history_tokenize"));
char **
chkr_stub_history_tokenize (char * arg0)
{
  stubs_chkr_check_str (arg0, CHKR_RO, "string");
  {
    char ** res;
    res = history_tokenize (arg0);
    if (res)
      {
	char **iter;

	for (iter = res; ; iter++)
	  {
	    stubs_chkr_set_right (iter, sizeof (char *), CHKR_RW);
	    if (*iter)
	      stubs_chkr_set_right (*iter, strlen (*iter), CHKR_RW);
	    else
	      break;
	  }
      }
    return res;
  }
}
#endif /* HAVE_history_tokenize */

