/*  Gtk+ User Interface Builder
 *  Copyright (C) 1998  Damon Chaplin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#ifndef __PROJECT_H__
#define __PROJECT_H__


/* Error codes used when loading/saving projects */
typedef enum
{
  GB_OK				= 0,
  GB_EOF			= 1,
  GB_FILE_OPEN_ERROR		= 2,
  GB_FILE_READ_ERROR		= 3,
  GB_FILE_WRITE_ERROR		= 4,
  GB_INVALID_LINE		= 5,
  GB_INVALID_VALUE		= 6,
  GB_INVALID_ENTITY		= 7,
  GB_START_TAG_EXPECTED		= 8,
  GB_END_TAG_EXPECTED		= 9,
  GB_DATA_EXPECTED		= 10,
  GB_CLASS_NAME_MISSING		= 11,
  GB_CLASS_UNKNOWN		= 12,
  GB_INVALID_COMPONENT		= 13,
  GB_CHDIR_ERROR		= 14
} GbStatusCode;

/* These are used to contain the size of the window manager borders around
   our windows, and are used to show/hide windows in the same positions.
   If they are -ve then don't use them. */
extern gint windows_x_offset;
extern gint windows_y_offset;

/* Components are the windows/dialog boxes/popup menus making up the project */

/* Deselect all components */
void	    project_clear_component_selection	(void);

gboolean    project_add_component		(GtkWidget     *widget,
						 gchar	       *name);
void	    project_rename_component		(GtkWidget     *widget,
						 gchar	       *name);
void	    project_delete_component		(GtkWidget     *widget);

/* Iterate over the components - for saving/writing source code */
void	    project_foreach_component		(GtkCallback	callback,
						 gpointer	callback_data);

/* These add windows to the current project, e.g. menu editor windows, which
   are destroyed in project_clear (), i.e. when opening another project. */
void	    project_add_window			(GtkWidget     *window);
void	    project_remove_window		(GtkWidget     *window);

#endif	/* __PROJECT_H__ */
