/*  Gtk+ User Interface Builder
 *  Copyright (C) 1998  Damon Chaplin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#ifndef __TREE_H__
#define __TREE_H__

void tree_init				(void);
void tree_show				(GtkWidget		*widget,
					 gpointer		 data);
gint tree_hide				(GtkWidget		*widget,
					 gpointer		 data);
void tree_add_widget			(GtkWidget		*widget);
void tree_insert_widget_parent		(GtkWidget		*parent,
					 GtkWidget		*child);
void tree_rename_widget			(GtkWidget		*widget,
					 gchar			*name);
void tree_delete_widget			(GtkWidget		*widget);
void tree_remove_widget_parent		(GtkWidget		*parent,
					 GtkWidget		*child);
void tree_select_widget			(GtkWidget		*widget,
					 gboolean		 select);
void tree_clear_selection		(void);

#endif /* __TREE_H__ */
