/* Lamps and Beacons - Color-Reactiveness for Gnome
   Copyright (C) 1997, 1998 Free Software Foundation

   The Gnome Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The Gnome Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the Gnome Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Author: Eckehard Berns  */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <gdk/gdkx.h>
#include <gtk/gtkmain.h>
#include <gtk/gtksignal.h>
#include "gnome-lamp.h"

/* timeout in msecs for blinking lamps */
#define GNOME_LAMP_TIMEOUT 200


static char * lamp1_xpm[] = {
"29 29 169 2",
"  	c None",
". 	c #000000",
"+ 	c #404040",
"@ 	c #4D4D4D",
"# 	c #3A3A3A",
"$ 	c #616161",
"% 	c #949494",
"& 	c #A5A5A5",
"* 	c #A3A3A3",
"= 	c #9C9C9C",
"- 	c #929292",
"; 	c #858585",
"> 	c #6A6A6A",
", 	c #939393",
"' 	c #AFAFAF",
") 	c #B7B7B7",
"! 	c #B9B9B9",
"~ 	c #B6B6B6",
"{ 	c #AEAEAE",
"] 	c #A2A2A2",
"^ 	c #848484",
"/ 	c #737373",
"( 	c #545454",
"_ 	c #9A9A9A",
": 	c #B2B2B2",
"< 	c #C0C0C0",
"[ 	c #CACACA",
"} 	c #CDCDCD",
"| 	c #C9C9C9",
"1 	c #BEBEBE",
"2 	c #B0B0B0",
"3 	c #9F9F9F",
"4 	c #8E8E8E",
"5 	c #7C7C7C",
"6 	c #696969",
"7 	c #4F4F4F",
"8 	c #7D7D7D",
"9 	c #AAAAAA",
"0 	c #BDBDBD",
"a 	c #CECECE",
"b 	c #DBDBDB",
"c 	c #E1E1E1",
"d 	c #DADADA",
"e 	c #CCCCCC",
"f 	c #BABABA",
"g 	c #A8A8A8",
"h 	c #959595",
"i 	c #828282",
"j 	c #6E6E6E",
"k 	c #5B5B5B",
"l 	c #353535",
"m 	c #9B9B9B",
"n 	c #C3C3C3",
"o 	c #D6D6D6",
"p 	c #E9E9E9",
"q 	c #F3F3F3",
"r 	c #E6E6E6",
"s 	c #D4D4D4",
"t 	c #ACACAC",
"u 	c #999999",
"v 	c #717171",
"w 	c #5D5D5D",
"x 	c #484848",
"y 	c #646464",
"z 	c #C2C2C2",
"A 	c #D5D5D5",
"B 	c #E8E8E8",
"C 	c #F1F1F1",
"D 	c #E5E5E5",
"E 	c #D3D3D3",
"F 	c #989898",
"G 	c #494949",
"H 	c #222222",
"I 	c #787878",
"J 	c #979797",
"K 	c #A9A9A9",
"L 	c #BCBCBC",
"M 	c #D9D9D9",
"N 	c #DEDEDE",
"O 	c #D8D8D8",
"P 	c #A7A7A7",
"Q 	c #818181",
"R 	c #5A5A5A",
"S 	c #474747",
"T 	c #2B2B2B",
"U 	c #777777",
"V 	c #8F8F8F",
"W 	c #A0A0A0",
"X 	c #C7C7C7",
"Y 	c #CBCBCB",
"Z 	c #C6C6C6",
"` 	c #9E9E9E",
" .	c #8D8D8D",
"..	c #7B7B7B",
"+.	c #686868",
"@.	c #555555",
"#.	c #424242",
"$.	c #6F6F6F",
"%.	c #ADADAD",
"&.	c #B4B4B4",
"*.	c #838383",
"=.	c #727272",
"-.	c #606060",
";.	c #4E4E4E",
">.	c #3C3C3C",
",.	c #262626",
"'.	c #868686",
").	c #A1A1A1",
"!.	c #909090",
"~.	c #767676",
"{.	c #676767",
"].	c #565656",
"^.	c #454545",
"/.	c #343434",
"(.	c #1D1D1D",
"_.	c #898989",
":.	c #888888",
"<.	c #7F7F7F",
"[.	c #757575",
"}.	c #4B4B4B",
"|.	c #3B3B3B",
"1.	c #2A2A2A",
"2.	c #121212",
"3.	c #707070",
"4.	c #666666",
"5.	c #7A7A7A",
"6.	c #595959",
"7.	c #4C4C4C",
"8.	c #3E3E3E",
"9.	c #2F2F2F",
"0.	c #1F1F1F",
"a.	c #414141",
"b.	c #5C5C5C",
"c.	c #626262",
"d.	c #535353",
"e.	c #3D3D3D",
"f.	c #303030",
"g.	c #101010",
"h.	c #4A4A4A",
"i.	c #525252",
"j.	c #383838",
"k.	c #2D2D2D",
"l.	c #212121",
"m.	c #131313",
"n.	c #3F3F3F",
"o.	c #363636",
"p.	c #1C1C1C",
"q.	c #080808",
"r.	c #1E1E1E",
"s.	c #292929",
"t.	c #2C2C2C",
"u.	c #282828",
"v.	c #232323",
"w.	c #141414",
"x.	c #090909",
"y.	c #0D0D0D",
"z.	c #373737",
"A.	c #505050",
"B.	c #0E0E0E",
"C.	c #0F0F0F",
"D.	c #0A0A0A",
"E.	c #2E2E2E",
"F.	c #242424",
"G.	c #191919",
"H.	c #272727",
"I.	c #1A1A1A",
"J.	c #151515",
"K.	c #161616",
"L.	c #070707",
"                                                          ",
"                                                          ",
"                                                          ",
"                          . . .                           ",
"                    . . . + @ # . . .                     ",
"                  . $ % & * = - ; > # .                   ",
"                . , ' ) ! ~ { ] % ^ / ( .                 ",
"              . _ : < [ } | 1 2 3 4 5 6 7 .               ",
"            . 8 9 0 a b c d e f g h i j k l .             ",
"            . m ' n o p q r s < t u ; v w x .             ",
"          . y m ' z A B C D E < t F ; v w G H .           ",
"          . I J K L e M N O [ ! P % Q j R S T .           ",
"        . . U V W 2 1 X Y Z L { `  ...+.@.#.T . .         ",
"        . . $.; % ] %.&.) &.t W - *.=.-.;.>.,.. .         ",
"        . . -.I '.- m ).* )._ !.^ ~.{.].^./.(.. .         ",
"        . . x > ~.Q _.4 V  .:.<.[.+.R }.|.1.2.. .         ",
"        . 3.. R 4.$.~.5...5.[.j y 6.7.8.9.0.. . .         ",
"        . 4.. a.( b.c.4.{.4.c.k d.G e.f.H g.. . .         ",
"        . 6.6 . a.h.7 i.d.i.7 G a.j.k.l.m.. . . .         ",
"        . }.6.4.. /.>.n.+ 8.|.o.9.,.p.g.. q.. . .         ",
"          . x ( w . r.s.t.T u.v.(.w.x.. y.. . .           ",
"          . z.a.h.A.. . . B.C.D.. . . C.. . . .           ",
"            . E.o.|.n.+ n.. . . F.G.y.. . . .             ",
"              . l.H.1.T 1.H.l.I.2.q.. . . .               ",
"                . . J.K.J.2.y.L.. . . . .                 ",
"                    . . . . . . . . .                     ",
"                                                          ",
"                                                          ",
"                                                          "};


static char lamp1_mask_rgb[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40,
0x4d, 0x4d, 0x4d, 0x3a, 0x3a, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x61, 0x61,
0x94, 0x94, 0x94, 0xa5, 0xa5, 0xa5, 0xa3, 0xa3, 0xa3, 0x9c, 0x9c, 0x9c, 0x92,
0x92, 0x92, 0x85, 0x85, 0x85, 0x6a, 0x6a, 0x6a, 0x3a, 0x3a, 0x3a, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x93, 0x93, 0x93, 0xaf, 0xaf, 0xaf, 0xb7, 0xb7, 0xb7, 0xb9,
0xb9, 0xb9, 0xb6, 0xb6, 0xb6, 0xae, 0xae, 0xae, 0xa2, 0xa2, 0xa2, 0x94, 0x94,
0x94, 0x84, 0x84, 0x84, 0x73, 0x73, 0x73, 0x54, 0x54, 0x54, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9a, 0x9a, 0x9a, 0xb2,
0xb2, 0xb2, 0xc0, 0xc0, 0xc0, 0xca, 0xca, 0xca, 0xcd, 0xcd, 0xcd, 0xc9, 0xc9,
0xc9, 0xbe, 0xbe, 0xbe, 0xb0, 0xb0, 0xb0, 0x9f, 0x9f, 0x9f, 0x8e, 0x8e, 0x8e,
0x7c, 0x7c, 0x7c, 0x69, 0x69, 0x69, 0x4f, 0x4f, 0x4f, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x7d, 0x7d, 0x7d, 0xaa, 0xaa, 0xaa, 0xbd, 0xbd, 0xbd, 0xce, 0xce,
0xce, 0xdb, 0xdb, 0xdb, 0xe1, 0xe1, 0xe1, 0xda, 0xda, 0xda, 0xcc, 0xcc, 0xcc,
0xba, 0xba, 0xba, 0xa8, 0xa8, 0xa8, 0x95, 0x95, 0x95, 0x82, 0x82, 0x82, 0x6e,
0x6e, 0x6e, 0x5b, 0x5b, 0x5b, 0x35, 0x35, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9b, 0x9b,
0x9b, 0xaf, 0xaf, 0xaf, 0xc3, 0xc3, 0xc3, 0xd6, 0xd6, 0xd6, 0xe9, 0xe9, 0xe9,
0xf3, 0xf3, 0xf3, 0xe6, 0xe6, 0xe6, 0xd4, 0xd4, 0xd4, 0xc0, 0xc0, 0xc0, 0xac,
0xac, 0xac, 0x99, 0x99, 0x99, 0x85, 0x85, 0x85, 0x71, 0x71, 0x71, 0x5d, 0x5d,
0x5d, 0x48, 0x48, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x64, 0x64, 0x64, 0x9b, 0x9b, 0x9b, 0xaf, 0xaf, 0xaf,
0xc2, 0xc2, 0xc2, 0xd5, 0xd5, 0xd5, 0xe8, 0xe8, 0xe8, 0xf1, 0xf1, 0xf1, 0xe5,
0xe5, 0xe5, 0xd3, 0xd3, 0xd3, 0xc0, 0xc0, 0xc0, 0xac, 0xac, 0xac, 0x98, 0x98,
0x98, 0x85, 0x85, 0x85, 0x71, 0x71, 0x71, 0x5d, 0x5d, 0x5d, 0x49, 0x49, 0x49,
0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x78, 0x78, 0x78, 0x97, 0x97, 0x97, 0xa9, 0xa9, 0xa9, 0xbc, 0xbc, 0xbc, 0xcc,
0xcc, 0xcc, 0xd9, 0xd9, 0xd9, 0xde, 0xde, 0xde, 0xd8, 0xd8, 0xd8, 0xca, 0xca,
0xca, 0xb9, 0xb9, 0xb9, 0xa7, 0xa7, 0xa7, 0x94, 0x94, 0x94, 0x81, 0x81, 0x81,
0x6e, 0x6e, 0x6e, 0x5a, 0x5a, 0x5a, 0x47, 0x47, 0x47, 0x2b, 0x2b, 0x2b, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x77, 0x77, 0x8f,
0x8f, 0x8f, 0xa0, 0xa0, 0xa0, 0xb0, 0xb0, 0xb0, 0xbe, 0xbe, 0xbe, 0xc7, 0xc7,
0xc7, 0xcb, 0xcb, 0xcb, 0xc6, 0xc6, 0xc6, 0xbc, 0xbc, 0xbc, 0xae, 0xae, 0xae,
0x9e, 0x9e, 0x9e, 0x8d, 0x8d, 0x8d, 0x7b, 0x7b, 0x7b, 0x68, 0x68, 0x68, 0x55,
0x55, 0x55, 0x42, 0x42, 0x42, 0x2b, 0x2b, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0x6f, 0x6f, 0x85, 0x85, 0x85, 0x94, 0x94,
0x94, 0xa2, 0xa2, 0xa2, 0xad, 0xad, 0xad, 0xb4, 0xb4, 0xb4, 0xb7, 0xb7, 0xb7,
0xb4, 0xb4, 0xb4, 0xac, 0xac, 0xac, 0xa0, 0xa0, 0xa0, 0x92, 0x92, 0x92, 0x83,
0x83, 0x83, 0x72, 0x72, 0x72, 0x60, 0x60, 0x60, 0x4e, 0x4e, 0x4e, 0x3c, 0x3c,
0x3c, 0x26, 0x26, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x60, 0x60, 0x60, 0x78, 0x78, 0x78, 0x86, 0x86, 0x86, 0x92, 0x92, 0x92,
0x9b, 0x9b, 0x9b, 0xa1, 0xa1, 0xa1, 0xa3, 0xa3, 0xa3, 0xa1, 0xa1, 0xa1, 0x9a,
0x9a, 0x9a, 0x90, 0x90, 0x90, 0x84, 0x84, 0x84, 0x76, 0x76, 0x76, 0x67, 0x67,
0x67, 0x56, 0x56, 0x56, 0x45, 0x45, 0x45, 0x34, 0x34, 0x34, 0x1d, 0x1d, 0x1d,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x48, 0x48,
0x6a, 0x6a, 0x6a, 0x76, 0x76, 0x76, 0x81, 0x81, 0x81, 0x89, 0x89, 0x89, 0x8e,
0x8e, 0x8e, 0x8f, 0x8f, 0x8f, 0x8d, 0x8d, 0x8d, 0x88, 0x88, 0x88, 0x7f, 0x7f,
0x7f, 0x75, 0x75, 0x75, 0x68, 0x68, 0x68, 0x5a, 0x5a, 0x5a, 0x4b, 0x4b, 0x4b,
0x3b, 0x3b, 0x3b, 0x2a, 0x2a, 0x2a, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0x5a, 0x5a, 0x66,
0x66, 0x66, 0x6f, 0x6f, 0x6f, 0x76, 0x76, 0x76, 0x7a, 0x7a, 0x7a, 0x7b, 0x7b,
0x7b, 0x7a, 0x7a, 0x7a, 0x75, 0x75, 0x75, 0x6e, 0x6e, 0x6e, 0x64, 0x64, 0x64,
0x59, 0x59, 0x59, 0x4c, 0x4c, 0x4c, 0x3e, 0x3e, 0x3e, 0x2f, 0x2f, 0x2f, 0x1f,
0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x41, 0x41, 0x54, 0x54, 0x54, 0x5c, 0x5c,
0x5c, 0x62, 0x62, 0x62, 0x66, 0x66, 0x66, 0x67, 0x67, 0x67, 0x66, 0x66, 0x66,
0x62, 0x62, 0x62, 0x5b, 0x5b, 0x5b, 0x53, 0x53, 0x53, 0x49, 0x49, 0x49, 0x3d,
0x3d, 0x3d, 0x30, 0x30, 0x30, 0x22, 0x22, 0x22, 0x10, 0x10, 0x10, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x41, 0x41, 0x41, 0x4a, 0x4a, 0x4a, 0x4f, 0x4f, 0x4f,
0x52, 0x52, 0x52, 0x53, 0x53, 0x53, 0x52, 0x52, 0x52, 0x4f, 0x4f, 0x4f, 0x49,
0x49, 0x49, 0x41, 0x41, 0x41, 0x38, 0x38, 0x38, 0x2d, 0x2d, 0x2d, 0x21, 0x21,
0x21, 0x13, 0x13, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x34, 0x34, 0x34, 0x3c, 0x3c, 0x3c, 0x3f, 0x3f, 0x3f, 0x40,
0x40, 0x40, 0x3e, 0x3e, 0x3e, 0x3b, 0x3b, 0x3b, 0x36, 0x36, 0x36, 0x2f, 0x2f,
0x2f, 0x26, 0x26, 0x26, 0x1c, 0x1c, 0x1c, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x1e, 0x1e, 0x1e, 0x29, 0x29, 0x29, 0x2c, 0x2c, 0x2c, 0x2b, 0x2b,
0x2b, 0x28, 0x28, 0x28, 0x23, 0x23, 0x23, 0x1d, 0x1d, 0x1d, 0x14, 0x14, 0x14,
0x09, 0x09, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x0f, 0x0f, 0x0f,
0x0a, 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 
};

static GdkColor gnome_lamp_clear   = { 0, 0xaaaa, 0xaaaa, 0xaaaa };
static GdkColor gnome_lamp_red     = { 0, 0xaaaa, 0x0000, 0x0000 };
static GdkColor gnome_lamp_green   = { 0, 0x0000, 0xaaaa, 0x0000 };
static GdkColor gnome_lamp_blue    = { 0, 0x0000, 0x0000, 0xaaaa };
static GdkColor gnome_lamp_yellow  = { 0, 0xaaaa, 0xaaaa, 0x0000 };
static GdkColor gnome_lamp_aqua    = { 0, 0x0000, 0xaaaa, 0xaaaa };
static GdkColor gnome_lamp_purple  = { 0, 0xaaaa, 0x0000, 0xaaaa };


/*
 * utils
 */

static GHashTable *type_hash(void)
{
	static GHashTable *hash = NULL;

	if (!hash) {
		static GnomeLampType lt[] = {
			{"idle", NULL, NULL, "C"},
			{"busy", NULL, NULL, "G"},
			{"input", NULL, NULL, "B"},
			{"warning", NULL, NULL, "Y"},
			{"error", NULL, NULL, "R"},
			{"proc00", NULL, NULL, "C"},
			{"proc10", NULL, NULL, "C"},
			{"proc20", NULL, NULL, "C"},
			{"proc30", NULL, NULL, "C"},
			{"proc40", NULL, NULL, "C"},
			{"proc50", NULL, NULL, "C"},
			{"proc60", NULL, NULL, "C"},
			{"proc70", NULL, NULL, "C"},
			{"proc80", NULL, NULL, "C"},
			{"proc90", NULL, NULL, "C"},
			{NULL, NULL, NULL, ""}
		};
		GnomeLampType *p;
		hash = g_hash_table_new(g_str_hash, g_str_equal);
		for (p = lt; p->name; p++)
			g_hash_table_insert(hash, p->name, p);
	}
	return hash;
}


static void
seqchar_to_color(char c, GdkColor *color_return)
{
	switch (c) {
	case 'R':
	case 'r':
		*color_return = gnome_lamp_red;
		break;
	case 'G':
	case 'g':
		*color_return = gnome_lamp_green;
		break;
	case 'B':
	case 'b':
		*color_return = gnome_lamp_blue;
		break;
	case 'Y':
	case 'y':
		*color_return = gnome_lamp_yellow;
		break;
	case 'A':
	case 'a':
		*color_return = gnome_lamp_aqua;
		break;
	case 'P':
	case 'p':
		*color_return = gnome_lamp_purple;
		break;
	default:
		*color_return = gnome_lamp_clear;
		break;
	}
}


/*
 * timer and widget list
 */

static guint gnome_lamp_timer = 0;
static GList *gnome_lamp_list = NULL;

static void
gnome_lamp_list_add(GnomeLamp *lamp)
{
	g_return_if_fail(lamp != NULL);
	g_return_if_fail(GNOME_IS_LAMP(lamp));

	if (!gnome_lamp_list) {
		gnome_lamp_list = g_list_alloc();
		gnome_lamp_list->data = lamp;
		return;
	}
	g_list_append(gnome_lamp_list, lamp);
}


static void
gnome_lamp_list_remove(GnomeLamp *lamp)
{
	g_return_if_fail(lamp != NULL);
	g_return_if_fail(GNOME_IS_LAMP(lamp));

	if (!gnome_lamp_list) return;
	gnome_lamp_list = g_list_remove(gnome_lamp_list, lamp);
}


static void
gnome_lamp_foreach(gpointer data, gpointer user_data)
{
	gint *handled = user_data;
	GnomeLamp *lamp = data;
	GdkColor color;

	g_return_if_fail(data != NULL);
	g_return_if_fail(user_data != NULL);
	g_return_if_fail(GNOME_IS_LAMP(lamp));

	if (!lamp->color_seq[0]) return;
	if (!lamp->color_seq[1]) return;
	*handled = TRUE;
	lamp->index++;
	if (!lamp->color_seq[lamp->index]) lamp->index = 0;
	/* TODO: this should just draw a cached pixmap for speedups */
	seqchar_to_color(lamp->color_seq[lamp->index], &color);
	gnome_lamp_set_color(lamp, &color);
}


static gint
gnome_lamp_timer_callback(gpointer data)
{
	gint handled = FALSE;

	if (!gnome_lamp_list) {
		gnome_lamp_timer = 0;
		return FALSE;
	}
	g_list_foreach(gnome_lamp_list, gnome_lamp_foreach, &handled);
	if (!handled)
		gnome_lamp_timer = 0;
	return handled;
}


static void
start_timer(void)
{
	if (gnome_lamp_timer) return;
	gnome_lamp_timer = gtk_timeout_add(GNOME_LAMP_TIMEOUT,
					   gnome_lamp_timer_callback,
					   NULL);
}


/*
 * widget
 */

static void
gnome_lamp_destroy(GtkObject *object)
{
	GtkObjectClass *object_class;

	g_return_if_fail (object != NULL);
	g_return_if_fail (GNOME_IS_LAMP (object));

	gnome_lamp_list_remove(GNOME_LAMP(object));

	object_class = gtk_type_class(gnome_pixmap_get_type());
	if (object_class->destroy)
		(* object_class->destroy)(object);

}

static void
gnome_lamp_class_init(GtkObjectClass *klass)
{
	klass->destroy = gnome_lamp_destroy;
}

static void
gnome_lamp_init(GnomeLamp *lamp)
{
	gnome_pixmap_load_xpm_d(GNOME_PIXMAP(lamp), lamp1_xpm);
	lamp->mask = lamp1_mask_rgb;
	lamp->color = gnome_lamp_clear;
	lamp->color_seq[0] = 'C';
	lamp->color_seq[1] = 0;
	lamp->index = 0;
	gnome_lamp_set_color(lamp, &lamp->color);
	gnome_lamp_list_add(lamp);
}

guint
gnome_lamp_get_type(void)
{
	static guint new_type = 0;
	if (!new_type) {
		GtkTypeInfo type_info = {
			"GnomeLamp",
			sizeof(GnomeLamp),
			sizeof(GnomeLampClass),
			(GtkClassInitFunc)gnome_lamp_class_init,
			(GtkObjectInitFunc)gnome_lamp_init,
			(GtkArgSetFunc) NULL,
			(GtkArgGetFunc) NULL
		};
		new_type = gtk_type_unique(gnome_pixmap_get_type(), &type_info);
	}
	return new_type;
}

GtkWidget *
gnome_lamp_new(void)
{
	return gtk_type_new(gnome_lamp_get_type());
}

GtkWidget *
gnome_lamp_new_with_color(const GdkColor *color)
{
	GtkWidget *w;

	g_return_val_if_fail(color != NULL, NULL);
	w = gtk_type_new(gnome_lamp_get_type());
	gnome_lamp_set_color(GNOME_LAMP(w), color);
	return w;
}

GtkWidget *
gnome_lamp_new_with_type(const char *type)
{
	GtkWidget *w;

	g_return_val_if_fail(type != NULL, NULL);
	w = gtk_type_new(gnome_lamp_get_type());
	gnome_lamp_set_type(GNOME_LAMP(w), type);
	return w;
}

void
gnome_lamp_set_type(GnomeLamp *lamp, const char *type)
{
	GnomeLampType *entry;

	g_return_if_fail(lamp != NULL);
	g_return_if_fail(type != NULL);
	g_return_if_fail(GNOME_IS_LAMP(lamp));

	entry = g_hash_table_lookup(type_hash(), (char *)type);
	g_return_if_fail(entry != NULL);

	if (entry->pixmap) {
		/* TODO: setup new pixmap */
	}
	if (entry->mask) {
		lamp->mask = entry->mask;
	}
	if (entry->color_seq[0]) {
		gnome_lamp_set_sequence(lamp, entry->color_seq);
	}
}

void
gnome_lamp_set_sequence(GnomeLamp *lamp, const char *sequence)
{
	GdkColor color;

	g_return_if_fail(lamp != NULL);
	g_return_if_fail(sequence != NULL);
	g_return_if_fail(GNOME_IS_LAMP(lamp));
	g_return_if_fail(sequence[0] != 0);
	g_return_if_fail(strlen(sequence) <= GNOME_LAMP_MAX_SEQUENCE);

	strcpy(lamp->color_seq, sequence);
	lamp->index = 0;
	if (strlen(lamp->color_seq) > 1) {
		start_timer();
	}
	seqchar_to_color(lamp->color_seq[0], &color);
	gnome_lamp_set_color(lamp, &color);
}

/* FORCE_* is for testing only. If both are 0, the type of the visual
 * determines which routine to use */
#define FORCE_STRIPPLE  0
#define FORCE_FULL      0
/* should the drawing be done in an extra image or is it faster to draw
 * directly into the pixmap? */
#define USE_IMAGE       0
/* color context is ways faster than rasters best_color_get */
#define USE_CC          1
#define ALWAYS_USE_CC   0

#if FORCE_STRIPPLE
#undef FORCE_FULL
#define FORCE_FULL 0
#endif

static void
gnome_lamp_set_pixmap_color(GnomeLamp *lamp)
{
	GdkGC *gc;
	guint32 red, green, blue;
	gint w, h, x, y;
	GdkVisual *visual;
#if !FORCE_STRIPPLE
	guint32 r, g, b;
#if USE_IMAGE
	GdkImage *image;
#endif
#endif
#if USE_CC
	GdkColorContext *cc;
#if ALWAYS_USE_CC || (!FORCE_STRIPPLE)
	gint failed;
#endif
#endif /* USE_CC */
	const unsigned char *p;
	GdkColormap *cmap;
	GdkColor c;

	red = lamp->color.red;
	green = lamp->color.green;
	blue = lamp->color.blue;
	gdk_window_get_size(GNOME_PIXMAP(lamp)->pixmap, &w, &h);
#if 1
	/* FIXME: is it save to use imlibs visual/colormap? */
	visual = gdk_imlib_get_visual();
	cmap = gdk_imlib_get_colormap();
#else
	/* this can produce warnings from color context about non-default
	 * visual */
	visual = gtk_widget_get_visual(GTK_WIDGET(lamp));
	cmap = gtk_widget_get_colormap(GTK_WIDGET(lamp));
#endif
	gc = gdk_gc_new(GNOME_PIXMAP(lamp)->pixmap);
#if USE_CC
	cc = gdk_color_context_new(visual, cmap);
#endif
#if !FORCE_STRIPPLE && !FORCE_FULL
#if USE_CC
	if ((cc->mode != GDK_CC_MODE_TRUE) &&
	    (cc->mode != GDK_CC_MODE_MY_GRAY))
#else
	/* what was PSEUDO_COLOR again? 8-bit? I think so... */
	if ((visual->type != GDK_VISUAL_GRAYSCALE) &&
	    (visual->type != GDK_VISUAL_TRUE_COLOR) &&
	    (visual->type != GDK_VISUAL_DIRECT_COLOR))
#endif
	     {
#endif
#if !FORCE_FULL
		c.red = red; c.green = green; c.blue = blue;
#if USE_CC
#if !ALWAYS_USE_CC
		/* it might be better to use imlib's best-color-match in modes
		 * where colormap entries are short. I need only one call to
		 * the function, so speed is no problem here. */
		gdk_imlib_best_color_get(&c);
#else /* ALWAYS_USE_CC */
		c.pixel = gdk_color_context_get_pixel(cc, red, green, blue, &failed);
#endif /* ALWAYS_USE_CC */

		gdk_color_context_free(cc);
#else /* !USE_CC */
		gdk_imlib_best_color_get(&c);
#endif /* !USE_CC */
		gdk_gc_set_foreground(gc, &c);
		p = lamp->mask;
		for (y = 0; y < h; y ++) {
			const char *p1 = p;
			p += w * 3;
			if (y % 2) p1 += 3;
			for (x = y % 2; x < w; x += 2, p1 += 6) {
				if (!*p1) continue;
				gdk_draw_point(GNOME_PIXMAP(lamp)->pixmap,
					       gc, x, y);
			}
		}
		gdk_gc_destroy(gc);
		if (GTK_WIDGET_VISIBLE(lamp))
			gtk_widget_queue_draw(GTK_WIDGET(lamp));
#endif /* !FORCE_FULL */
#if !FORCE_STRIPPLE && !FORCE_FULL
		return;
	}
#endif
#if !FORCE_STRIPPLE
#if USE_IMAGE
	image = gdk_image_get(GNOME_PIXMAP(lamp)->pixmap, 0, 0, w, h);
#endif
	p = lamp->mask;
	for (y = 0; y < h; y++) {
		for (x = 0; x < w; x++) {
			if (!*p) {
				p += 3;
				continue;
			}
			/* this is a better, but more expensive calculation */
			r = ((guint32)(*p++) * red) >> 7;
			g = ((guint32)(*p++) * green) >> 7;
			b = ((guint32)(*p++) * blue) >> 7;
			if (r > 0xffff) {
				g += (r - 0xffff) >> 2;
				b += (r - 0xffff) >> 2;
			}
			if (g > 0xffff) {
				r += (g - 0xffff) >> 2;
				b += (g - 0xffff) >> 2;
			}
			if (b > 0xffff) {
				r += (b - 0xffff) >> 2;
				g += (b - 0xffff) >> 2;
			}
			if (r > 0xffff) r = 0xffff;
			if (g > 0xffff) g = 0xffff;
			if (b > 0xffff) b = 0xffff;
			c.red = r;
			c.green = g;
			c.blue = b;
			/*
			c.red = ((guint32)(*p++) * red) >> 8;
			c.green = ((guint32)(*p++) * green) >> 8;
			c.blue = ((guint32)(*p++) * blue) >> 8;
			 */
#if USE_CC
			c.pixel = gdk_color_context_get_pixel(cc, c.red, c.green, c.blue, &failed);
#else
			gdk_imlib_best_color_get(&c);
#endif
#if USE_IMAGE
			gdk_image_put_pixel(image, x, y, c.pixel);
#else
			gdk_gc_set_foreground(gc, &c);
			gdk_draw_point(GNOME_PIXMAP(lamp)->pixmap, gc, x, y);
#endif
		}
	}
#if USE_IMAGE
	gdk_draw_image(GNOME_PIXMAP(lamp)->pixmap, gc, image, 0, 0, 0, 0, w, h);
	gdk_image_destroy(image);
#endif
	gdk_gc_destroy(gc);
#if USE_CC
	gdk_color_context_free(cc);
#endif
	if (GTK_WIDGET_VISIBLE(lamp))
		gtk_widget_queue_draw(GTK_WIDGET(lamp));
#endif /* !FORCE_STRIPPLE */
}

void
gnome_lamp_set_color(GnomeLamp *lamp, const GdkColor *color)
{
	g_return_if_fail(lamp != NULL);
	g_return_if_fail(color != NULL);
	g_return_if_fail(GNOME_IS_LAMP(lamp));

	lamp->color = *color;
	gnome_lamp_set_pixmap_color(lamp);
}


/*
 * window lamp/beacons
 */

typedef struct _WmLampMapping WmLampMapping;
struct _WmLampMapping {
	char *type;
	guint32 hint; /* CARD32 */
};

WmLampMapping enl_mappings[] = {
	{ GNOME_LAMP_IDLE, 7 },
	{ GNOME_LAMP_BUSY, 1 },
	{ GNOME_LAMP_INPUT, 13 },
	{ GNOME_LAMP_WARNING, 3 },
	{ GNOME_LAMP_ERROR, 5 },
	{ GNOME_LAMP_PROC0, 23 },
	{ GNOME_LAMP_PROC10, 25 },
	{ GNOME_LAMP_PROC20, 27 },
	{ GNOME_LAMP_PROC30, 29 },
	{ GNOME_LAMP_PROC40, 31 },
	{ GNOME_LAMP_PROC50, 33 },
	{ GNOME_LAMP_PROC60, 35 },
	{ GNOME_LAMP_PROC70, 37 },
	{ GNOME_LAMP_PROC80, 39 },
	{ GNOME_LAMP_PROC90, 41 },
	{ NULL, 0 }
};

static void
gnome_lamp_set_win_app_state(GdkWindow *window, guint32 value)
{
	Display *disp;
	static Atom atom = None;
	Window win;

	g_return_if_fail(window != NULL);

	disp = GDK_WINDOW_XDISPLAY(window);
	win = GDK_WINDOW_XWINDOW(window);
	if (atom == None)
		atom = XInternAtom(disp, "WIN_APP_STATE", FALSE);
	XChangeProperty(disp, win, atom, XA_CARDINAL, 32, PropModeReplace,
			(guchar *)&value, 1);
}

static void
gnome_lamp_update_window_type(GtkWindow *window, char *type)
{
	g_return_if_fail(window != NULL);
	g_return_if_fail(GTK_IS_WINDOW(window));
	g_return_if_fail(type != NULL);
	g_return_if_fail(GTK_WIDGET(window)->window != NULL);

	gnome_lamp_set_window_type(window, type);
	gtk_signal_disconnect_by_func(GTK_OBJECT(window),
				      (GtkSignalFunc)gnome_lamp_update_window_type,
				      type);
	g_free(type);
}

void
gnome_lamp_set_window_type(GtkWindow *window, const char *type)
{
	WmLampMapping *p;

	g_return_if_fail(window != NULL);
	g_return_if_fail(GTK_IS_WINDOW(window));
	g_return_if_fail(type != NULL);

	/* TODO: currently only rasters WIN_APP_STATE hints are supported */
	for (p = enl_mappings; p->type; p++) {
		if (0 == strcmp(type, p->type))
			break;
	}
	if (!p->type) {
		g_warning("gnome_lamp_set_window_type: couldn't find type \"%s\"\n", type);
		return;
	}
	if (GTK_WIDGET(window)->window) {
		gnome_lamp_set_win_app_state(GTK_WIDGET(window)->window,
					     p->hint);
	} else {
		/* connect to the realise signal once, so we can update the wm
		 * hints as soon as a GdkWindow is created */
		gtk_signal_connect_after(GTK_OBJECT(window), "realize",
					 (GtkSignalFunc)gnome_lamp_update_window_type,
					 g_strdup(type));
	}
}

