/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB/NJN
 *
 *	$Id: kcreate.c,v 6.1 96/11/23 19:42:22 nevin Rel $
 *
 *	Function:	- creates an OTB process
 *			- does not make a Trollius kernel request
 *			- essentially a packaged fork and exec
 *			- redirects created process's stdio
 *	Accepts:	- child program name
 *			- argv
 *			- stdio file descriptors (0 if no redirection)
 *	Returns:	- (to parent) child pid or ERROR
 */

#include <errno.h>
#include <stdio.h>

#include <typical.h>

/*
 * external functions
 */
extern void		_cipc_cleanup();

/*
 * private functions
 */
static void		redirect_stdio();


int
kcreate(pathname, argv, fds)

char			*pathname;
char			*argv[];
int			*fds;

{
	int		pid;			/* UNIX process ID */

	switch((pid = fork())) {

		case ERROR:			/* bad fork */
		return(LAMERROR);

		case 0:				/* child */
		_cipc_cleanup();
		redirect_stdio(fds);
		execvp(pathname, argv);
		exit(errno);
		break;
	}
/*
 * parent
 */
	return(pid);
}


/*
 *	redirect_stdio
 *
 *	Function:	- redirect process stdio
 *	Accepts:	- target file descriptors or NULL if no redirection
 */
static void
redirect_stdio(fds)

int			*fds;

{
	if (fds) {
		dup2(fds[0], fileno(stdin));
		dup2(fds[1], fileno(stdout));
		dup2(fds[2], fileno(stderr));
	}
}
