/*
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Log:	fctl.c,v $
 * Revision 6.1  96/11/23  18:12:32  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:18:18  gdburns
 * Ohio Release
 * 
 * Revision 5.2.1.1  95/09/14  19:45:53  gdburns
 * Revise node parsing.
 * 
 * Revision 5.2  94/08/22  13:41:10  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  10:38:23  gdburns
 * Ohio Release
 * 
 * Revision 2.3.1.1  94/05/18  10:06:22  gdburns
 * Change name to fctl and minor facelift.
 * 
 * Revision 2.3  94/04/22  12:25:20  gdburns
 * Ohio Release
 *
 *	Function:	- command to control certain filed functions
 *	Accepts:	- see the "usage" variable
 */

#include <stdio.h>
#include <sys/param.h>

#include <args.h>
#include <freq.h>
#include <net.h>
#include <priority.h>
#include <terror.h>
#include <typical.h>

#ifndef MAXPATHLEN
#define MAXPATHLEN	1024
#endif

/*
 * local functions
 */
static void		help();

/*
 * local variables
 */
static char		*usage =
		"fctl [-hS] [-s <descno>] [<directory>] <nodes>\n";
static char		pwd[MAXPATHLEN];


main(argc, argv)

int   			argc;    
char   			*argv[];

{
	int		n_index;		/* index of node entry */
	int		nodeid;			/* value of node entry */
	int		n_flags;		/* extra node entry info */
	int		tfd;			/* filed descriptor # */
/*
 * Parse the command line.
 */
	validopts("Ssh");
	followed("s");
	exclusive("Ss");

	if (do_args(&argc, argv)) {
		fprintf(stderr, usage);
		exit(errno);
	}
/*
 * Check for help request.
 */
	if (opt_taken('h')) {
		help();
		exit(0);
	}
/*
 * Attach to kernel.
 */
	if (kinit(PRCMD)) {
		terror("fctl (kinit)");
		exit(errno);
	}

	if ((nid_parse(&argc, argv)) || (errno = (argc <= 2) ? 0 : EUSAGE)) {
		fprintf(stderr, usage);
		kexit(errno);
	}
/*
 * Loop through all specified nodes.
 */
	nid_get(&n_index, &nodeid, &n_flags);

	if (n_index < 0) {
		fprintf(stderr, usage);
		kexit(EUSAGE);
	}

	do {
/*
 * Clean up file descriptors in filed.
 */
		if (opt_taken('S')) {
			if (rfrmfd(nodeid, NOTFD)) lamfail("fctl (rfrmfd)");
		} else if (opt_taken('s')) {
		 	intparam('s', &tfd);
			if (rfrmfd(nodeid, tfd)) lamfail("fctl (rfrmfd)");
		}
/*
 * Print the current working directory.
 */
		else if (argc == 1) {
			if (rfgetwd(nodeid, pwd) == 0)
					lamfail("fctl (rfgetwd)");
			printf("%s: %s\n", nid_fmt(nodeid), pwd);
		}
/*
 * Change current working directory.
 */
		else if (argc == 2) {
			if (rfchdir(nodeid, argv[1]))
					lamfail("fctl (rfchdir)");
		}

		nid_get(&n_index, &nodeid, &n_flags);
	} while (n_index);

	kexit(0);
	return(0);
}

/*
 *	  help
 *
 *	  Function:	- prints helpful information on the fctl command
 */
static void
help()

{
	printf("\nSynopsis:	fctl [options] <nodes> [<dir>]\n");
	printf("\nDescription:	Control file daemon operations.\n");
	printf("\nOptions:	-h	Print this help message.\n");
	printf("\t\t-S	Blow away all open descriptors.\n");
	printf("\t\t-s <#>	Blow away one specific descriptor.\n");
	printf("\t\t<dir>	Change to new working directory.\n");
	printf("\t\tnone	Print current working directory.\n");
	mnusage();
	printf("\t\th (local), o (origin), N (all)\n");
	printf("\nExample:	fctl h -S\n");
	printf("\t\t\t\"Clean up (reset) the file daemon.\"\n");
}
