/*
 *	Ohio Trollius
 *      Copyright 1996 The Ohio State University
 *      GDB/RBD
 *
 *	$Id: T.c,v 6.1 96/11/23 19:57:37 nevin Rel $
 * 
 *	Function:	- f2c F77 interface for libt functions
 */

#include <lam_config.h>

#include <string.h>
#include <stdlib.h>

#include <net.h>
#include <portable.h>
#include <t_types.h>
#include <terror.h>

/*
 * external functions
 */
extern char		*f2cstring();

/*
 * F77/C interface
 */
#if FORTRANNOUNDERSCORE
#define fttime_		fttime
#define igntp_		igntp
#define ignall_		ignall
#define igncmp_		igncmp
#define igndid_		igndid
#define igndtp_		igndtp
#define ignjon_		ignjon
#define ignotb_		ignotb
#define igorgn_		igorgn
#define igrtp_		igrtp
#define i2ltot_		i2ltot
#define i2mltt_		i2mltt
#define i2mttl_		i2mttl
#define i2ttol_		i2ttol
#define i4ltot_		i4ltot
#define i4mltt_		i4mltt
#define i4mttl_		i4mttl
#define i4ttol_		i4ttol
#define f4ltot_		f4ltot
#define f4mltt_		f4mltt
#define f4mttl_		f4mttl
#define f4ttol_		f4ttol
#define f8ltot_		f8ltot
#define f8mltt_		f8mltt
#define f8mttl_		f8mttl
#define f8ttol_		f8ttol
#define gall_		gall
#define gcomps_		gcomps
#define gjones_		gjones
#define gnodes_		gnodes
#define gotbs_		gotbs
#define kentr_		kentr
#define kxit_		kxit
#define lamf_rfclose_	lamf_rfclose
#define lamf_rfread_	lamf_rfread
#define lamf_rfwrite_	lamf_rfwrite
#define lamf_rfopen_	lamf_rfopen
#define nsnd_		nsnd
#define nrcv_		nrcv
#define nprob_		nprob
#define tsnd_		tsnd
#define trcv_		trcv
#define trror_		trror
#define psndo_		psndo
#define psndc_		psndc
#define psnd_		psnd
#define prcvo_		prcvo
#define prcvc_		prcvc
#define prcv_		prcv
#elif FORTRANDOUBLEUNDERSCORE
#define lamf_rfclose_	lamf_rfclose__
#define lamf_rfread_	lamf_rfread__
#define lamf_rfwrite_	lamf_rfwrite__
#define lamf_rfopen_	lamf_rfopen__
#endif

/*
 * simple wrappers
 */
double fttime_() { return(ttime()); }
int4 igntp_(tp, msk) int4 *tp, *msk; { return(getntype(*tp, *msk)); }
int4 ignall_() { return(getnall()); }
int4 igncmp_() { return(getncomp()); }
int4 igndid_() { return(getnodeid()); }
int4 igndtp_() { return(getnodetype()); }
int4 ignjon_() { return(getnjones()); }
int4 ignotb_() { return(getnotb()); }
int4 igorgn_() { return(getorigin()); }
int4 igrtp_(nd) int4 *nd; { return(getrtype(*nd)); }
void i2ltot_(l, t) int2 *l, *t; { ltoti2(l, t); }
void i2mltt_(a, n) int2 *a; int *n; { mltoti2(a, *n); }
void i2mttl_(a, n) int2 *a; int *n; { mttoli2(a, *n); }
void i2ttol_(t, l) int2 *t, *l; { ttoli2(t, l); }
void i4ltot_(l, t) int4 *l, *t; { ltoti4(l, t); }
void i4mltt_(a, n) int4 *a; int *n; { mltoti4(a, *n); }
void i4mttl_(a, n) int4 *a; int *n; { mttoli4(a, *n); }
void i4ttol_(t, l) int4 *t, *l; { ttoli4(t, l); }
void f4ltot_(l, t) float4 *l, *t; { ltotf4(l, t); }
void f4mltt_(a, n) float4 *a; int *n; { mltotf4(a, *n); }
void f4mttl_(a, n) float4 *a; int *n; { mttolf4(a, *n); }
void f4ttol_(t, l) float4 *t, *l; { ttolf4(t, l); }
void f8ltot_(l, t) float8 *l, *t; { ltotf8(l, t); }
void f8mltt_(a, n) float8 *a; int *n; { mltotf8(a, *n); }
void f8mttl_(a, n) float8 *a; int *n; { mttolf8(a, *n); }
void f8ttol_(t, l) float8 *t, *l; { ttolf8(t, l); }
void gall_(n, nn, ie) int4 *n, *nn, *ie;
		{ *ie = getall(n, *nn) ? errno : 0; }
void gcomps_(n, nn, ie) int4 *n, *nn, *ie;
		{ *ie = getcomps(n, *nn) ? errno : 0; }
void gjones_(n, nn, ie) int4 *n, *nn, *ie;
		{ *ie = getjones(n, *nn) ? errno : 0; }
void gnodes_(n, nn, tp, msk, ie) int4 *n, *nn, *tp, *msk, *ie;
		{ *ie = getnodes(n, *nn, *tp, *msk) ? errno : 0; }
void gotbs_(n, nn, ie) int4 *n, *nn, *ie;
		{ *ie = getotbs(n, *nn) ? errno : 0; }
void kxit_(er) int *er; { kexit(*er); }
void lamf_rfclose_(ud, ie) int *ud, *ie; { *ie = rfclose(*ud) ? errno : 0; }
void lamf_rfread_(ud, b, i, o, ie) int *ud; char *b; int *i, *o, *ie;
		{ *ie = (*o = rfread(*ud, b, *i)) < 0 ? errno : 0; }
void lamf_rfwrite_(ud, b, i, o, ie) int *ud; char *b; int *i, *o, *ie;
		{ *ie = (*o = rfwrite(*ud, b, *i)) < 0 ? errno : 0; }

/*
 * thicker wrappers
 */
void
trror_(pstr, lstr)

char			*pstr;
unsigned int		lstr;

{
	char		*cstr;

	cstr = f2cstring(pstr, lstr);
	if (cstr) {
		terror(cstr);
		free(cstr);
	}
}

void
lamf_rfopen_(udesc, file_name, flags, modes, ierror, lstr)

int			*udesc;		/* file descriptor (returned) */
char			*file_name;	/* complete node:file spec */
int			*flags; 	/* open flags */
int			*modes;		/* modes for O_CREAT */
int			*ierror;	/* return error code */
unsigned int		lstr;		/* file_name length */

{
	char		*cstr;

	if ((cstr = f2cstring(file_name, lstr)) == 0) {
		*ierror = errno;
		return;
	}

	if ((*udesc = rfopen(cstr, *flags, *modes)) < 0) {
		*ierror = errno;
	} else {
		*ierror = 0;
	}

	free(cstr);
}

void
kentr_(name, priority, ierror, lstr)

char			*name;		/* process name */
int			*priority;	/* process priority */
int			*ierror;	/* 0 or error code */
unsigned int		lstr;

{
	char		*cstr;

	if ((cstr = f2cstring(name, lstr)) == 0) {
		*ierror = errno;
		return;
	}

	if (kenter(cstr, *priority)) {
		*ierror = errno;
	} else {
		*ierror = 0;
	}

	free(cstr);
}

void
nsnd_(nnode, nevent, ntype, nlength, nflags, ndata, ndsize, nmsg, ierror)

int			*nnode;
int			*nevent;
int			*ntype;
int			*nlength;
int			*nflags;
int			*ndata;
int			*ndsize;
char			*nmsg;
int			*ierror;

{
	struct nmsg	nhead;

	nhead.nh_node = *nnode;
	nhead.nh_event = *nevent;
	nhead.nh_type = *ntype;
	nhead.nh_length = *nlength;
	nhead.nh_flags = *nflags;
	nhead.nh_msg = nmsg;

	memcpy((char *) nhead.nh_data, (char *) ndata,
		(*ndsize > sizeof(nhead.nh_data))
               	? sizeof(nhead.nh_data) : *ndsize);

	if (nsend(&nhead)) {
		*ierror = errno;
	} else {
		*ierror = 0;
	}
}

void
nrcv_(nevent, ntype, nlength, nflags, ndata, ndsize, nmsg, ierror)

int 			*nevent;
int			*ntype;
int			*nlength;
int			*nflags;
int			*ndata;
int			*ndsize;
char			*nmsg;
int			*ierror;
			
{
	struct nmsg	nhead;

	nhead.nh_event = *nevent;
	nhead.nh_type = *ntype;
	nhead.nh_length = *nlength;
	nhead.nh_flags = *nflags;
	nhead.nh_msg = nmsg;

	if (nrecv(&nhead)) {
		*ierror = errno;
	} else {
		*ierror = 0;
		memcpy((char *) ndata, (char *) nhead.nh_data,
			(*ndsize > sizeof(nhead.nh_data))
                        ? sizeof(nhead.nh_data) : *ndsize);
                *ntype = nhead.nh_type;
                *nlength = nhead.nh_length;
	}
}

void
nprob_(nevent, ntype, nlength, nflags, nready, ierror)

int 			*nevent;
int			*ntype;
int			*nlength;
int			*nflags;
int			*nready;
int			*ierror;
			
{
	struct nmsg	nhead;

	nhead.nh_event = *nevent;
	nhead.nh_type = *ntype;

	if ((*nready = nprobe(&nhead)) > 0) {
                *ntype = nhead.nh_type;
                *nlength = nhead.nh_length;
                *nflags = nhead.nh_flags;
		*ierror = 0;
	}

	else if (*nready < 0) {
		*ierror = errno;
	} else {
		*ierror = 0;
	}
}

void
tsnd_(nnode, nevent, ntype, nlength, nflags, ndata, ndsize, nmsg, ierror)

int			*nnode;
int			*nevent;
int			*ntype;
int			*nlength;
int			*nflags;
int			*ndata;
int			*ndsize;
char			*nmsg;
int			*ierror;

{
	struct nmsg	nhead;		/* network message descriptor */

	nhead.nh_node = *nnode;
	nhead.nh_event = *nevent;
	nhead.nh_type = *ntype;
	nhead.nh_length = *nlength;
	nhead.nh_flags = *nflags;
	nhead.nh_msg = nmsg;
 
	memcpy((char *) nhead.nh_data, (char *) ndata,
		(*ndsize > sizeof(nhead.nh_data))
                ? sizeof(nhead.nh_data) : *ndsize);

	if (tsend(&nhead)) {
		*ierror = errno;
	} else {
		*ierror = 0;
	}
}

void
trcv_(nevent, ntype, nlength, nflags, ndata, ndsize, nmsg, ierror)

int			*nevent;
int			*ntype;
int			*nlength;
int			*nflags;
int			*ndata;
int			*ndsize;
char			*nmsg;
int			*ierror;

{
	struct nmsg	nhead;		/* network message descriptor */

	nhead.nh_event = *nevent;
	nhead.nh_type = *ntype;
	nhead.nh_length = *nlength;
	nhead.nh_flags = *nflags;
	nhead.nh_msg = nmsg;

	if (trecv(&nhead)) {
		*ierror = errno;
	} else {
		*ierror = 0;
		memcpy((char *) ndata, (char *) nhead.nh_data,
			(*ndsize > sizeof(nhead.nh_data))
                        ? sizeof(nhead.nh_data) : *ndsize);
                *ntype = nhead.nh_type;
                *nlength = nhead.nh_length;
	}
}

void
psndo_(pnode, pevent, ptype, ierror)

int4			*pnode;
int4			*pevent;
int4			*ptype;
int4			*ierror;

{
	struct nmsg	nhead;

	nhead.nh_node = *pnode;
	nhead.nh_event = *pevent;
	nhead.nh_type = *ptype;

	if (psendopen(&nhead)) {
		*ierror = errno;
	} else {
		*ierror = 0;
	}
}

void
psndc_(pnode, pevent, ptype, ierror)

int4			*pnode;
int4			*pevent;
int4			*ptype;
int4			*ierror;

{
	struct nmsg	nhead;

	nhead.nh_node = *pnode;
	nhead.nh_event = *pevent;
	nhead.nh_type = *ptype;

	if (psendclose(&nhead)) {
		*ierror = errno;
	} else {
		*ierror = 0;
	}
}

void
psnd_(pnode, pevent, ptype, plength, pflags, pdata, pdsize, pmsg, ierror)

int4			*pnode;
int4			*pevent;
int4			*ptype;
int4			*plength;
int4			*pflags;
int4			*pdata;
int4			*pdsize;
char			*pmsg;
int4			*ierror;

{
	struct nmsg	nhead;

	nhead.nh_node = *pnode;
	nhead.nh_event = *pevent;
	nhead.nh_type = *ptype;
	nhead.nh_length = *plength;
	nhead.nh_flags = *pflags;
	nhead.nh_msg = pmsg;

	memcpy((char *) nhead.nh_data, (char *) pdata,
		(*pdsize > sizeof(nhead.nh_data))
		? sizeof(nhead.nh_data) : *pdsize);

	if (psend(&nhead)) {
		*ierror = errno;
	} else {
		*ierror = 0;
	}
}

void
prcvo_(pevent, ptype, ierror)

int4			*pevent;
int4			*ptype;
int4			*ierror;

{
	struct nmsg	nhead;

	nhead.nh_event = *pevent;
	nhead.nh_type = *ptype;

	if (precvopen(&nhead)) {
		*ierror = errno;
	} else {
		*ierror = 0;
	}
}

void
prcvc_(pevent, ptype, ierror)

int4			*pevent;
int4			*ptype;
int4			*ierror;

{
	struct nmsg	nhead;

	nhead.nh_event = *pevent;
	nhead.nh_type = *ptype;

	if (precvclose(&nhead)) {
		*ierror = errno;
	} else {
		*ierror = 0;
	}
}

void
prcv_(pevent, ptype, plength, pflags, pdata, pdsize, pmsg, ierror)

int4			*pevent;
int4			*ptype;
int4			*plength;
int4			*pflags;
int4			*pdata;
int4			*pdsize;
char			*pmsg;
int4			*ierror;

{
	struct nmsg	nhead;

	nhead.nh_event = *pevent;
	nhead.nh_type = *ptype;
	nhead.nh_length = *plength;
	nhead.nh_flags = *pflags;
	nhead.nh_msg = pmsg;

	if (precv(&nhead)) {
		*ierror = errno;
	} else {
		*ierror = 0;
		memcpy((char *) pdata, (char *) nhead.nh_data,
			(*pdsize > sizeof(nhead.nh_data))
			? sizeof(nhead.nh_data) : *pdsize);
		*ptype = nhead.nh_type;
		*plength = nhead.nh_length;
	}
}
