/*
 *	Software for Humanity
 *	Public Domain
 *	K&R
 *
 *	This program is freely distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 *	$Id: itoa.c,v 6.1 96/11/23 19:57:58 nevin Rel $
 * 
 *	Function:	- K&R itoa()
 */

#include <string.h>

/*
 * local functions
 */
static void		reverse();

void
sfh_itoa(n, s)

char			*s;
int			n;

{
	int		i;
	int		sign;

	if ((sign = n) < 0) n = -n;

	i = 0;

	do {
		s[i++] = n % 10 + '0';
	} while ((n /= 10) > 0);

	if (sign < 0) s[i++] = '-';

	s[i] = '\0';
	reverse(s);
}

/*
 *	reverse
 *
 *	Function:	- reverse string in place
 *	Accepts:	- string
 */
static void
reverse(s)

char			s[];

{
	int		c;
	int		i;
	int		j;

	for (i = 0, j = strlen(s) - 1; i < j; i++, j--) {
		c = s[i];
		s[i] = s[j];
		s[j] = c;
	}
}

/*
 * backwards compatibility
 */
void itoa(n, s) char *s; int n;
{ sfh_itoa(n, s); }
