/*
 *	Ohio Trollius
 *	Copyright 1994 The Ohio State University
 *	RBD
 *
 *	$Log:	prime.c,v $
 * Revision 6.1  96/11/23  19:58:15  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:48:48  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  13:57:07  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  10:57:02  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:35:05  gdburns
 * Ohio Release
 * 
 * Revision 2.2.1.1  94/01/04  08:34:08  raja
 * Do not rely on sqrt() in libm.
 * 
 * Revision 2.2  92/04/30  14:40:43  trillium
 * Ohio Release
 *
 * Revision 2.1  91/11/11  14:24:22  raja
 * initial revision
 *
 *	Function:	- test and generate prime numbers
 *				- is_prime(): test is number is prime
 *				- next_prime(): return the next prime number
 */

#include <portable.h>
#include <typical.h>

/*
 *	is_prime
 *
 *	Function:	- check if the number is prime
 *	Accepts:	- a positive integer
 *	Returns:	- TRUE or FALSE
 */
int
is_prime(n)

int4			n;

{
	int4		i;		/* favourite counter */
	int4		i_2;		/* i squared */

	if (n <= 0) {
		return(FALSE);
	} else if ((n == 1) || (n == 2)) {
		return(TRUE);
	} else if ((n % 2) == 0) {
		return(FALSE);
	}
/*
 * Loop through all odd number smaller than the largest divisor
 * checking if any divides evenly the given number.
 */
	else {
		for (i = 3, i_2 = 9; i_2 <= n; i += 2) {
			if ((n % i) == 0) {
				return(FALSE);
			}

			i_2 += (i + 1) << 2;
		}
	}

	return(TRUE);
}

/*
 *	next_prime
 *
 *	Function:	- get the first prime # >= the given number
 *	Accepts:	- a positive number
 *	Returns:	- a prime number or ERROR
 */
int4
next_prime(n)

int4			n;

{
	if (n < 0) {
		return((int4) ERROR);
	} else if (n < 1) {
		return((int4) 1);
	} else if (n < 2) {
		return((int4) 2);
	} else {
/*
 * Find the next prime number in the general case.
 */
		if ((n % 2) == 0) {
			n++;
		}

		while (! is_prime(n)) {
			n += 2;
		}

		return(n);
	}
}
