/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB/RBD/NJN
 *
 *	$Id: portable.h,v 6.1 96/11/23 21:55:24 nevin Rel $
 *
 *	Function:	- Put some order into a world of chaos.
 *			- Anybody without an 8 bit byte can get lost.
 */

#ifndef _PORTABLE
#define _PORTABLE

#include <lam_config.h>
#include <limits.h>

/*
 * To const or not to const.
 */
#ifndef CONST
#if __STDC__ || defined(c_plusplus) || defined(__cplusplus)
#define CONST const
#else
#define CONST
#endif
#endif

/*
 * Can you believe that some compilers would default char to unsigned char?
 */
#ifndef SIGNED
#if __STDC__ || defined(c_plusplus) || defined(__cplusplus)
#define SIGNED signed
#else
#define SIGNED
#endif
#endif

/*
 * Path name separator.
 */
#ifndef DOS
#define STRDIR		'/'
#define STRSDIR		"/"
#else
#define STRDIR		'\\'
#define STRSDIR		"\\"
#endif

/*
 * Maximum size of a filename path.
 */
#if defined(PATH_MAX)
#define LAM_PATH_MAX	(PATH_MAX + 1)
#elif defined(_POSIX_PATH_MAX)
#define LAM_PATH_MAX	(_POSIX_PATH_MAX + 1)
#else
#define LAM_PATH_MAX	256
#endif

/*
 * Portable datatypes.
 */
#if SIZEOF_SHORT == 2
typedef short		int2;
typedef unsigned short	uint2;
#elif SIZEOF_INT == 2
typedef int		int2;
typedef unsigned int	uint2;
#endif

#if SIZEOF_INT == 4
typedef int		int4;
typedef unsigned int	uint4;
#define stoi4		stoi
#define atoi4		atoi
#elif SIZEOF_SHORT == 4
typedef short		int4;
typedef unsigned short	uint4;
#define stoi4		stos
#define atoi4		atos
#elif SIZEOF_LONG == 4
typedef long		int4;
typedef unsigned long	uint4;
#define stoi4		stol
#define atoi4		atol
#endif

#if SIZEOF_LONG	== 8
typedef	long		int8;
typedef unsigned long	uint8;
#elif SIZEOF_INT == 8
typedef int		int8;
typedef unsigned int	uint8;
#endif

#if SIZEOF_FLOAT == 4
typedef float		float4;
#endif

#if SIZEOF_FLOAT == 8
typedef float		float8;
#elif SIZEOF_DOUBLE == 8
typedef double		float8;
#endif


#define INT4_NIL	((int4) 0)
#define INT4_MAX	((int4) 0x7FFFFFFF)
#define INT4_MIN	((int4) 0x80000000)
#define INT4_LSB	((int4) 0xFF)		/* least significant byte */
#define INT4_LSN	((int4) 0x0F)		/* least significant nibble */
#define INT4_MSN	((int4) 0xF0)		/* most significant nibble */
#define	INT4_SIGN	((int4) 0x80000000)	/* sign bit of an int4 */

#define UINT4_MAX	((uint4) 0xFFFFFFFF)	/* maximum uint4 */

#endif
