/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB
 *
 *	$Id: rpi.lamd.h,v 6.1 96/11/22 14:12:45 nevin Rel $
 *
 *	Function:	- RPI implementation for LAM daemon
 *			- constants and templates
 */

#ifndef _RPI_LAMD_H
#define _RPI_LAMD_H

#include <net.h>

/*
 * lamd request
 */
struct lamd_req {
	struct nmsg	lmq_msg_data;		/* data LAM message */
	struct nmsg	lmq_msg_ack;		/* ack LAM message */
	struct nmsg	lmq_msg_ger;		/* GER LAM message */
	int		lmq_state;		/* progress state */
	int		lmq_flags;		/* misc. flags */
	int		lmq_ndata;		/* #bytes to ship */
	int		lmq_ndata_moved;	/* #bytes shipped */
};

/*
 * lamd request states
 */
#define LAMD_START	0			/* no communication yet */
#define LAMD_ACK	1			/* ship ack next */
#define LAMD_TAIL	2			/* shipping data tail */
#define LAMD_GER	4			/* GER protocol */
#define LAMD_DONE	3			/* completed */

/*
 * lamd request flags
 */
#define LAMD_RECVMODE	1			/* recv or probe */
#define LAMD_SSEND	2			/* msg is synchronous */

/*
 * polling defaults
 */
#ifndef MPIL_LPD_BASE
#define MPIL_LPD_BASE	50000
#endif

#ifndef MPIL_LPD_MAX
#define MPIL_LPD_MAX	1000000
#endif

#endif	/* _RPI_LAMD_H */
