/*
 *	Software for Humanity
 *	Public Domain
 *	RBD/GDB/NJN
 *
 *	This program is freely distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 *	$Id: sfh.h,v 6.1 96/11/22 14:14:07 nevin Rel $
 *
 *	Function:	- constants, templates and prototypes
 */

#ifndef _SFH_H
#define _SFH_H

#include <sys/types.h>
#include <netinet/in.h>

/*
 * prototypes of Software for Humanity functions
 */
#ifndef __ARGS
#if __STDC__ || defined(c_plusplus) || defined(__cplusplus)
#define __ARGS(a)	a
#else
#define __ARGS(a)	()
#endif
#endif

extern void	sfh_itoa __ARGS((int, char *));

extern char	*sfh_path_find __ARGS((char *, char **, int));
extern char	*sfh_path_env_find __ARGS((char *, int));

extern int	sfh_sock_open_srv_inet_stm __ARGS((int *));
extern int	sfh_sock_open_clt_inet_stm __ARGS((unsigned char *, int));
extern int	sfh_sock_open_srv_unix_stm __ARGS((char *));
extern int	sfh_sock_open_clt_unix_stm __ARGS((char *));
extern int	sfh_sock_accept_tmout __ARGS((int, int));
extern int	sfh_sock_open_srv_inet_dgm __ARGS((int *));
extern int	sfh_sock_open_clt_inet_dgm __ARGS((void));
extern void	sfh_sock_fill_inet_addr __ARGS((unsigned char *, int,
						struct sockaddr_in *));
extern int	sfh_send_fd __ARGS((int, int));
extern int	sfh_recv_fd __ARGS((int));

#ifdef __cplusplus
extern "C" {
#endif

#endif	/* _SFH_H */
