/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: cartmap.c,v 6.1 96/11/23 22:51:14 nevin Rel $
 *
 *	Function:	- map processes to cartesian coordinates
 *	Accepts:	- communicator
 *			- # dimensions
 *			- # procs per dimension
 *			- dimension periodicity
 *			- caller's new rank (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Cart_map(comm, ndims, dims, periods, newrank)

MPI_Comm		comm;
int			ndims;
int			*dims;
int			*periods;
int			*newrank;

{
	int		nprocs;
	int		rank;
	int		size;
	int		errcode;
	int		i;
	int		*p;

	lam_initerr();
	lam_setfunc(BLKMPICARTMAP);
/*
 * Check the arguments.
 */
	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPICARTMAP, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (LAM_IS_INTER(comm)) {
		return(lam_errfunc(comm,
			BLKMPICARTMAP, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (ndims < 1) {
		return(lam_errfunc(comm,
			BLKMPICARTMAP, lam_mkerr(MPI_ERR_DIMS, 0)));
	}

	if ((dims == 0) || (periods == 0) || (newrank == 0)) {
		return(lam_errfunc(comm,
			BLKMPICARTMAP, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Compute the # of processes in the grid.
 */
	nprocs = 1;
	for (i = 0, p = dims; i < ndims; ++i, ++p) {
		if (*p <= 0) {
			return(lam_errfunc(comm, BLKMPICARTMAP,
					lam_mkerr(MPI_ERR_DIMS, 0)));
		}

		nprocs *= *p;
	}
/*
 * Check that number of processes <= size of communicator.
 */
	errcode = MPI_Comm_size(comm, &size);
	if (errcode != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPICARTMAP, errcode));
	}

	if (nprocs > size) {
		return(lam_errfunc(comm, BLKMPICARTMAP,
					lam_mkerr(MPI_ERR_DIMS, 0)));
	}
/*
 * Compute my new rank.
 */
	errcode = MPI_Comm_rank(comm, &rank);
	if (errcode != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPICARTMAP, errcode));
	}

	*newrank = ((rank < 0) || (rank >= nprocs)) ? MPI_UNDEFINED : rank;

	lam_resetfunc(BLKMPICARTMAP);
	return(MPI_SUCCESS);
}
