/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: cdisconnect.c,v 6.1 96/11/22 13:34:48 nevin Rel $
 *
 *	Function:	- completes all pending communication on
 *			  a communicator and frees it
 *	Accepts:	- communicator
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <errno.h>
#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>


int
MPI_Comm_disconnect(comm)

MPI_Comm		*comm;

{
	MPI_Request 	*reqs;			/* array of pending requests */
	MPI_Status	*stats;			/* array of status */
	struct _req	*r;			/* request */
	int		npend = 0;		/* number of pending requests */
	int		err;			/* error return */
	int4		ccid;			/* collective context ID */
	int		i;
	
	lam_initerr();
	lam_setfunc(BLKMPICOMMDISC);

	LAM_TRACE(lam_tr_cffstart(BLKMPICOMMDISC));
/*
 * Find number of pending requests on the communicator.
 */
	ccid = lam_pt2coll((*comm)->c_contextid);
	
	for (r = lam_rq_top; r; r = r->rq_next) {
		if (r->rq_state != LAM_RQSDONE && (r->rq_cid == ccid
				|| r->rq_cid == (*comm)->c_contextid)) {
			npend++;
		}
	}
/*
 * Create array of pending requests to wait on.
 */
	reqs = (MPI_Request *) malloc((unsigned) npend * sizeof(MPI_Request));
	stats = (MPI_Status *) malloc((unsigned) npend * sizeof(MPI_Status));
	if ((reqs == 0) || (stats == 0)) {
		if (reqs) free((char *) reqs);
		if (stats) free((char *) stats);
		return(lam_errfunc(*comm, BLKMPICOMMDISC,
				lam_mkerr(MPI_ERR_OTHER, errno)));
	}

	for (i = 0, r = lam_rq_top; r; r = r->rq_next) {
		if (r->rq_state != LAM_RQSDONE && (r->rq_cid == ccid
				|| r->rq_cid == (*comm)->c_contextid)) {
			reqs[i++] = r;
		}
	}

	err = MPI_Waitall(npend, reqs, stats);

	free((char *) reqs);
	free((char *) stats);

	if (err) {
		return(lam_errfunc(*comm, BLKMPICOMMDISC, err));
	}
	
	LAM_TRACE(lam_tr_cffend(BLKMPICOMMDISC, -1, *comm, 0, 0));

	if ((err = MPI_Comm_free(comm)) != MPI_SUCCESS) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPICOMMDISC, err));
	}

        lam_resetfunc(BLKMPICOMMDISC);
	return(MPI_SUCCESS);
}
