/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio	State University
 *	NJN
 *
 *	$Id: infoget_f.c,v 6.1 96/11/22 13:44:37 nevin Rel $
 *
 *	Function:	- MPI_Info_get F77 wrapper
 */

#include <lam_config.h>

#include <errno.h>
#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <MPISYS.h>
#include <mpisys.h>

void
mpi_info_get_(i, k, l, v, f, ierr, nk, nv)

int	*i, *l,	*f, *ierr;
char	*k, *v;
int	nk, nv;

{
	char value[MPI_INFO_MAX_VALUELEN + 1];
	char *key;

	if (*l > nv) {
		lam_setfunc(BLKMPIINFOGET);
		*ierr =	lam_errfunc(MPI_COMM_WORLD, BLKMPIINFOGET,
					lam_mkerr(MPI_ERR_ARG, errno));
		return;
	}
	
	key = lam_F2C_string(k,	nk);
	if (key	== 0) {
		lam_setfunc(BLKMPIINFOGET);
		*ierr =	lam_errfunc(MPI_COMM_WORLD, BLKMPIINFOGET,
					lam_mkerr(MPI_ERR_OTHER, errno));
		return;
	}

	*ierr =	MPI_Info_get(GETHDL(*i), key, *l, value, f);

	if (*f)	{
		lam_C2F_string(value, v, nv);
	}
	
	free(key);
}
