/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio	State University
 *	NJN
 *
 *	$Id: spawn_f.c,v 6.1 96/11/22 13:44:37 nevin Rel $
 *
 *	Function:	- MPI_Spawn F77	wrapper
 */

#include <lam_config.h>

#include <errno.h>
#include <stdlib.h>

#include <args.h>
#include <blktype.h>
#include <mpi.h>
#include <MPISYS.h>
#include <mpisys.h>

void
mpi_spawn_(cmd,	av, maxp, info,	root, comm, icomm, ec, ierr, nc, na)

char			*cmd, *av;
int			*maxp, *info, *root, *comm, *icomm, *ec, *ierr;
int			nc, na;

{
	MPI_Comm	intercomm;		/* parent-child intercomm */
	char		**argv = 0;		/* C argument vector */
	char		*command;		/* C program name */
	int		*errs;			/* C errcode array */
/*
 * Check for special argument values.
 */
	if ((void *) ec == lam_F_errdontcare) {
		errs = MPI_ERRCODES_DONTCARE;
	} else {
		errs = ec;
	}

	if ((void *) av == lam_F_argvnull) {
		argv = MPI_ARGV_NULL;
	} else {
/*
 * Convert F77 argument	array to C argument vector.
 */
		if (lam_F2C_argv(av, na, &argv)) {
			lam_setfunc(BLKMPISPAWN);
			*ierr =	lam_errfunc(GETHDL(*comm), BLKMPISPAWN,
					    lam_mkerr(MPI_ERR_SPAWN, errno));
			return;
		}

		if (argv == 0) {
			argv = MPI_ARGV_NULL;
		}
	}
/*
 * Convert F77 command string to C string.
 */
	command	= lam_F2C_string(cmd, nc);
	if (command == 0) {
		argvfree(argv);
		lam_setfunc(BLKMPISPAWN);
		*ierr =	lam_errfunc(GETHDL(*comm), BLKMPISPAWN,
					lam_mkerr(MPI_ERR_SPAWN, errno));
		return;
	}

	*ierr =	MPI_Spawn(command, argv, *maxp,	GETHDL(*info), 
				*root, GETHDL(*comm), &intercomm, errs);

	lam_F_maketype(icomm, ierr, (void *) intercomm);
	argvfree(argv);
	free(command);
}
