/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio	State University
 *	RBD/NJN
 *
 *	$Id: startall_f.c,v 6.1 96/11/22 13:44:37 nevin Rel $
 *
 *	Function:	- MPI_Startall F77 wrapper
 */

#include <lam_config.h>

#include <errno.h>
#include <stdlib.h>

#include <mpi.h>
#include <MPISYS.h>
#include <mpisys.h>

void
mpi_startall_(c, r, ierr)

int	*c, *r,	*ierr;


{
	MPI_Request *rq;
	int	 i;

	rq = (MPI_Request *) malloc((unsigned) (*c) * sizeof(MPI_Request));
	if (rq == 0) {
		*ierr =	lam_mkerr(MPI_ERR_OTHER, errno);
		return;
	}
	for (i = 0; i <	*c; ++i)
		rq[i] =	GETHDL(r[i]);

	*ierr =	MPI_Startall(*c, rq);

	free((char *) rq);
}
