/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: getversion.c,v 6.1 96/11/22 13:34:52 nevin Rel $
 *
 *	Function:	- MPI library version
 *	Accepts:	- version (out)
 *			- sub version (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Get_version(version, subversion)

int			*version;
int			*subversion;

{
	lam_initerr();
	lam_setfunc(BLKMPIGETVERSION);

	if (version == 0 || subversion == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGETVERSION, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	*version = MPI_VERSION;
	*subversion = MPI_SUBVERSION;
	
	lam_resetfunc(BLKMPIGETVERSION);
	return(MPI_SUCCESS);
}
