/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD/NJN
 *
 *	$Id: grincl.c,v 6.1 96/11/23 22:52:20 nevin Rel $
 *
 *	Function:	- form a new group by range inclusion
 *	Accepts:	- original group
 *			- # of ranges
 *			- rank ranges
 *			- ptr new group
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>
#include <net.h>
#include <terror.h>

int
MPI_Group_range_incl(g, n, ranges, png)

MPI_Group		g;
int			n;
int			ranges[][3];
MPI_Group		*png;

{
	int		i, j;
	int		nproc;			/* # processes */
	int		first;			/* range first */
	int		last;			/* range last */
	int		end;			/* calculated end of range */
	int		stride;			/* range stride */
	struct _proc	**p, **q;		/* processes in groups */
	MPI_Group	ng;			/* new group */

	lam_initerr();
	lam_setfunc(BLKMPIGROUPRINCL);
/*
 * Check the arguments.
 */
	if (g == MPI_GROUP_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGROUPRINCL, lam_mkerr(MPI_ERR_GROUP, 0)));
	}

	if ((png == 0) || (n < 0) || ((n > 0) && (ranges == 0))) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGROUPRINCL, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	nproc = 0;
	for (i = 0; i < n; ++i) {

		if ((stride = ranges[i][2]) == 0) break;

		first = ranges[i][0];
		last = ranges[i][1];
		end = first + ((last - first) / stride) * stride;

		if (stride > 0) {
			if (first < 0 || first > last || end >= g->g_nprocs) {
				break;
			}
		} else {
			if (first >= g->g_nprocs || first < last || end < 0) {
				break;
			}
		}

		nproc += 1 + ((end - first) / stride);
	}

	if (i < n) {
		return(lam_errfunc(MPI_COMM_WORLD,
				BLKMPIGROUPRINCL, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Handle the trivial cases.
 */
	if (nproc == 0) {
		*png = MPI_GROUP_EMPTY;
		MPI_GROUP_EMPTY->g_refcount++;
		lam_resetfunc(BLKMPIGROUPRINCL);
		return(MPI_SUCCESS);
	}
/*
 * Allocate a new group.
 */
	ng = (MPI_Group) malloc((unsigned) sizeof(struct _group) +
					(nproc * sizeof(struct _proc *)));
	if (ng == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGROUPRINCL, lam_mkerr(MPI_ERR_OTHER, errno)));
	}

	ng->g_nprocs = nproc;
	ng->g_myrank = MPI_UNDEFINED;
	ng->g_refcount = 1;
	ng->g_procs = (struct _proc **) ((char *) ng + sizeof(struct _group));
/*
 * Fill the new group processes.
 */
	p = ng->g_procs;
	q = g->g_procs;

	for (i = 0; i < n; ++i) {

		stride = ranges[i][2];
		j = ranges[i][0];
		end = j + ((ranges[i][1] - j) / stride) * stride;
		
		for (; (stride > 0) ? (j <= end) : (j >= end); j += stride) {

			if (!(q[j]->p_mode & LAM_PFLAG)) {
				*p = q[j];
				(*p)->p_mode |= LAM_PFLAG;
				if (*p == lam_myproc) {
					ng->g_myrank = (int) (p - ng->g_procs);
				}
				++p;
			} else {
				for (q = ng->g_procs; q < p; ++q) {
					(*q)->p_mode &= ~LAM_PFLAG;
				}
				free(ng);
				return(lam_errfunc(MPI_COMM_WORLD,
						BLKMPIGROUPRINCL,
						lam_mkerr(MPI_ERR_ARG, 0)));
			}
		}
	}

	for (i = 0, p = ng->g_procs; i < nproc; ++i, ++p) {
		(*p)->p_refcount++;
		(*p)->p_mode &= ~LAM_PFLAG;
	}

	*png = ng;

	lam_resetfunc(BLKMPIGROUPRINCL);
	return(MPI_SUCCESS);
}
