/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: ibsend.c,v 6.1 96/11/23 22:52:26 nevin Rel $
 *
 *	Function:	- immediate buffered send
 *	Accepts:	- buffer
 *			- count
 *			- datatype
 *			- destination
 *			- tag
 *			- communicator
 *			- request (out)
 *	Returns: 	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>

/*
 * external functions
 */
extern void		lam_initerr();
extern void		lam_resetfunc();
extern void		lam_setfunc();
extern int		lam_errfunc();
extern int		_mpi_req_build();

int
MPI_Ibsend(buf, count, dtype, dest, tag, comm, preq)

void			*buf;
int			count;
MPI_Datatype		dtype;
int			dest;
int			tag;
MPI_Comm		comm;
MPI_Request		*preq;

{
	int		err;

	lam_initerr();
	lam_setfunc(BLKMPIIBSEND);
/*
 * Create the fake user request.  We do not add it into the
 * request list.  This is an exception to the design that says
 * that all active (inc. done) requests are to be found in the
 * request list but fake requests, really ibsend requests are
 * very exceptional MPI creatures.
 */
	*preq = MPI_REQUEST_NULL;
	err = _mpi_req_build(buf, count, dtype, dest, tag, comm,
			LAM_RQIFAKE, preq);
	if (err != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPIIBSEND, err));
	}

	(*preq)->rq_status.MPI_ERROR = MPI_SUCCESS;
	(*preq)->rq_status.MPI_SOURCE = MPI_PROC_NULL;
	(*preq)->rq_state = LAM_RQSDONE;
/*
 * Bsend() the message.
 */
	err = MPI_Bsend(buf, count, dtype, dest, tag, comm);
	if (err != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPIIBSEND, err));
	}

	lam_resetfunc(BLKMPIIBSEND);
	return(MPI_SUCCESS);
}
