/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD/GDB
 *
 *	$Id: irecv.c,v 6.1 96/11/23 22:52:41 nevin Rel $
 *
 *	Function:	- immediate receive
 *	Accepts:	- buffer
 *			- count
 *			- datatype
 *			- source
 *			- tag
 *			- communicator
 *			- ptr to request (returned value)
 *	Returns: 	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <mpitrace.h>
#include <rpisys.h>

/*
 * external functions
 */
extern void		lam_initerr();
extern void		lam_resetfunc();
extern void		lam_setfunc();
extern void		lam_tr_msg();
extern void		_mpi_req_add();
extern void		_mpi_req_blkclr();
extern void		_mpi_req_blkset();
extern int		lam_errfunc();
extern int		lam_tr_incff();
extern int		_mpi_req_advance();
extern int		_mpi_req_build();
extern int		_mpi_req_end();

int
MPI_Irecv(buf, count, dtype, src, tag, comm, req)

void			*buf;
int			count;
MPI_Datatype		dtype;
int			src;
int			tag;
MPI_Comm		comm;
MPI_Request		*req;

{
	int		err;			/* error code */
	int		fl_trace;		/* do tracing? */
	double		startt;			/* start time */

	lam_initerr();
	lam_setfunc(BLKMPIIRECV);

	if ((fl_trace = LAM_TRACE_TOP())) startt = MPI_Wtime();

	*req = MPI_REQUEST_NULL;
	err = _mpi_req_build(buf, count, dtype, src, tag, comm,
			LAM_RQIRECV, req);
	if (err != MPI_SUCCESS) return(lam_errfunc(comm, BLKMPIIRECV, err));

	err = _mpi_req_start(*req);
	if (err != MPI_SUCCESS) return(lam_errfunc(comm, BLKMPIIRECV, err));

	_mpi_req_add(*req);
	_mpi_req_blkclr();

	err = _mpi_req_advance();
	if (err != MPI_SUCCESS) return(lam_errfunc(comm, BLKMPIIRECV, err));
/*
 * Generate a run time trace.
 */
	if (fl_trace) {
		lam_tr_msg(TRTNOIO, startt, LAM_S2US(MPI_Wtime() - startt),
				0, src, tag, comm, dtype, count, 0, 0,
				(*req)->rq_seq, LAM_RQIRECV);
	}

	lam_resetfunc(BLKMPIIRECV);
	return(MPI_SUCCESS);
}
