/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: keyfree.c,v 6.1 96/11/23 22:52:50 nevin Rel $
 *
 *	Function:	- free attribute key
 *	Accepts:	- key value (inout)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>

/*
 * external functions
 */
extern struct _attrkey	*lam_getattr();

int
MPI_Keyval_free(key)

int			*key;

{
	int		err;
	
	lam_initerr();
	lam_setfunc(BLKMPIKEYFREE);
/*
 * Check the arguments.
 */
	if (key == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIKEYFREE, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Free the key, if it is valid.
 */
	if ((err = lam_freekey(*key)) != MPI_SUCCESS) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIKEYFREE, err));
	}

	*key = MPI_KEYVAL_INVALID;

	lam_resetfunc(BLKMPIKEYFREE);
	return(MPI_SUCCESS);
}
