/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: opcreate.c,v 6.1 96/11/23 22:53:35 nevin Rel $
 *
 *	Function:	- create a reduction operator
 *	Accepts:	- function
 *			- commutative flag
 *			- operator (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>

int
MPI_Op_create(func, commute, pop)

void			(*func)();
int			commute;
MPI_Op			*pop;

{
	int		class;
	MPI_Op		op;

	lam_initerr();
	lam_setfunc(BLKMPIOPCREATE);

	if ((pop == 0) || (func == 0)) {
		class = (pop == 0) ? MPI_ERR_OP : MPI_ERR_ARG;
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIOPCREATE, lam_mkerr(class, 0)));
	}

	op = (MPI_Op) malloc(sizeof(struct _op));
	if (op == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIOPCREATE, lam_mkerr(MPI_ERR_OTHER, errno)));
	}

	*pop = op;
	op->op_func = func;
	op->op_commute = commute;
	op->op_f77dtype = -1;
	op->op_flags = 0;
	
	lam_resetfunc(BLKMPIOPCREATE);
	return(MPI_SUCCESS);
}
