/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD/GDB
 *
 *	$Id: probe.c,v 6.1 96/11/23 22:53:44 nevin Rel $
 *
 *	Function:	- blocking check of incoming messages
 *			- message is not received
 *	Accepts:	- source rank
 *			- message tag
 *			- communicator
 *			- ptr to status (returned value)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <mpitrace.h>
#include <rpisys.h>

/*
 * external functions
 */
extern void		lam_initerr();
extern void		lam_resetfunc();
extern void		lam_setfunc();
extern void		lam_tr_msg();
extern void		_mpi_req_add();
extern void		_mpi_req_blkclr();
extern void		_mpi_req_blkset();
extern void		_mpi_req_rem();
extern int		lam_errfunc();
extern int		lam_mkerr();
extern int		lam_tr_incff();
extern int		_mpi_req_advance();
extern int		_mpi_req_build();
extern int		_mpi_req_destroy();
extern int		_mpi_req_start();
extern int		_mpi_req_end();

int
MPI_Probe(src, tag, comm, stat)

int			src;
int			tag;
MPI_Comm		comm;
MPI_Status		*stat;

{
	struct _req	request;		/* request structure */
	MPI_Request	req;			/* request */
	int		err;			/* error code */
	int		fl_trace;		/* do tracing? */
	double		startt;			/* start time */

	lam_initerr();

	if (stat == 0) {
		return(lam_errfunc(comm, BLKMPIPROBE,
				lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Handle the trivial case.
 */
	if (src == MPI_PROC_NULL) {
		stat->MPI_ERROR = MPI_SUCCESS;
		stat->MPI_SOURCE = MPI_PROC_NULL;
		stat->MPI_TAG = MPI_ANY_TAG;
		stat->st_count = 0;
		stat->st_nelem = 0;
		stat->st_length = 0;
		return(MPI_SUCCESS);
	}

	lam_setfunc(BLKMPIPROBE);

	if ((fl_trace = LAM_TRACE_TOP())) {
		startt = MPI_Wtime();
		_kio.ki_blktime = 0.0;
	}
/*
 * Build a probe request.
 * We pass MPI_BYTE just to keep the argument checker quiet.
 */
	req = &request;
	err = _mpi_req_build((char *) 0, 0, MPI_BYTE, src, tag, comm,
			LAM_RQIPROBE, &req);
	if (err != MPI_SUCCESS) return(lam_errfunc(comm, BLKMPIPROBE, err));
	
	err = _mpi_req_start(req);
	if (err != MPI_SUCCESS) return(lam_errfunc(comm, BLKMPIPROBE, err));

	_mpi_req_add(req);
	_mpi_req_blkclr();
	_mpi_req_blkset(req);

	err = _mpi_req_advance();
	if (err != MPI_SUCCESS) return(lam_errfunc(comm, BLKMPIPROBE, err));

	err = _mpi_req_end(req);
	if (err != MPI_SUCCESS) return(lam_errfunc(comm, BLKMPIPROBE, err));

	*stat = req->rq_status;

	_mpi_req_rem(req);

	err = _mpi_req_destroy(&req);
	if (err != MPI_SUCCESS) return(lam_errfunc(comm, BLKMPIPROBE, err));
/*
 * Generate a run time trace.
 */
	if (fl_trace) {
		lam_tr_msg(TRTNOIO, startt,
			LAM_S2US(MPI_Wtime() - startt - _kio.ki_blktime),
			LAM_S2US(_kio.ki_blktime), src, tag, comm,
			0, 0, 0, 0, 0, LAM_RQIPROBE);
	}

	lam_resetfunc(BLKMPIPROBE);
	return(MPI_SUCCESS);
}
