/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: sendrecv.c,v 6.1 96/11/23 22:54:07 nevin Rel $
 *
 *	Function:	- send and receive
 *	Accepts:	- send buffer
 *			- send count
 *			- send datatype
 *			- destination
 *			- send tag
 *			- receive buffer
 *			- receive count
 *			- receive datatype
 *			- source
 *			- receive tag
 *			- communicator
 *			- status (out)
 *	Returns: 	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Sendrecv(sbuf, scount, sdtype, dest, stag,
		rbuf, rcount, rdtype, src, rtag, comm, status)

void			*sbuf;
int			scount;
MPI_Datatype		sdtype;
int			dest;
int			stag;
void			*rbuf;
int			rcount;
MPI_Datatype		rdtype;
int			src;
int			rtag;
MPI_Comm		comm;
MPI_Status		*status;

{
	MPI_Request	req;			/* request */
	int		err;			/* error code */
	int		fl_trace;		/* do tracing? */

	lam_initerr();
	lam_setfunc(BLKMPISENDRECV);
/*
 * Check the arguments.
 */
	err = lam_chkarg(sbuf, scount, sdtype, dest, stag, comm);
	if (err != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPISENDRECV, err));
	}

	err = lam_chkarg(rbuf, rcount, rdtype, src, rtag, comm);
	if (err != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPISENDRECV, err));
	}

	if (status == 0) {
		return(lam_errfunc(comm,
			BLKMPISENDRECV, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Generate a start wrapper trace.
 */
	fl_trace = ((_kio.ki_rtf & RTF_TRON) == RTF_TRON);

	if (fl_trace) {
		lam_tr_wrapstart(BLKMPISENDRECV);
	}
/*
 * Send & receive.
 */
	err = MPI_Irecv(rbuf, rcount, rdtype, src, rtag, comm, &req);
	if (err != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPISENDRECV, err));
	}

	err = MPI_Send(sbuf, scount, sdtype, dest, stag, comm);
	if (err != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPISENDRECV, err));
	}

	err = MPI_Wait(&req, status);
	if (err != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPISENDRECV, err));
	}
/*
 * Generate an end wrapper trace.
 */
	if (fl_trace) lam_tr_wrapend(BLKMPISENDRECV);

	lam_resetfunc(BLKMPISENDRECV);
	return(MPI_SUCCESS);
}
