/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: shm.locks.sol.c,v 6.1 96/11/22 13:35:12 nevin Rel $
 *
 *	Function:	- Solaris lock routines
 */

#include <errno.h>
#include <synch.h>

/*
 * global variables
 */
int			_lock_poll;		/* not used in this RPI */
int			_lock_delay;		/* not used in this RPI */

/*
 *	_sol_lock
 *
 *	Function:	- get a lock
 *	Accepts:	- ptr lock
 *	Returns:	- 0 success or -1 error
 */
int
_sol_lock(lock)

sema_t			*lock;

{
	int		err;

	while ((err = sema_wait(lock)) == EINTR) ;

	if (err) {
		errno = err;
		return(-1);
	} else {
		return(0);
	}
}

/*
 *	sol_trylock
 *
 *	Function:	- tries to get a lock
 *	Accepts:	- ptr lock
 *	Returns:	- 0 if obtained, 1 if not obtained,  -1 if error
 */
int
_sol_trylock(lock)

sema_t			*lock;

{
	if ((errno = sema_trywait(lock))) {
		return((errno == EBUSY) ? 1 : 0);
	} else {
		return(0);
	}
}
