/*
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN/RBD
 *
 *	$Id: thindex.c,v 6.1.1.1 97/02/24 14:37:00 nevin Exp $
 *
 *	Function:	- create hindexed derived datatype
 *	Accepts:	- # blocks
 *			- block length array
 *			- block displacement array (in bytes)
 *			- element datatype
 *			- ptr new datatype
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>

int
MPI_Type_hindexed(count, lengths, disps, oldtype, newtype)

int			count;
int			*lengths;
MPI_Aint		*disps;
MPI_Datatype		oldtype;
MPI_Datatype		*newtype;

{
	MPI_Datatype	ntype;			/* new datatype */
	int		i;			/* favourite index */

	lam_initerr();
	lam_setfunc(BLKMPITHINDEX);
/*
 * Check the arguments.
 */
	if (oldtype == MPI_DATATYPE_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITHINDEX, lam_mkerr(MPI_ERR_TYPE, 0)));
	}

	if (count < 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITHINDEX, lam_mkerr(MPI_ERR_COUNT, 0)));
	}

	if ((newtype == 0) ||
			((count > 0) && ((lengths == 0) || (disps == 0)))) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITHINDEX, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Create the new datatype.
 */
	ntype = (MPI_Datatype) malloc(sizeof(struct _dtype));
	if (ntype == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITHINDEX, lam_mkerr(MPI_ERR_OTHER, errno)));
	}

	if (count > 0) {
		ntype->dt_disps = (MPI_Aint *) malloc((unsigned) (count *
					(sizeof(MPI_Aint) + sizeof(int))));
		if (ntype->dt_disps == 0) {
			free((char *) ntype);
			return(lam_errfunc(MPI_COMM_WORLD, BLKMPITHINDEX,
					lam_mkerr(MPI_ERR_OTHER, errno)));
		}

		ntype->dt_lengths = (int *) (((char *) ntype->dt_disps) +
						(count * sizeof(MPI_Aint)));
	} else {
		ntype->dt_disps = 0;
		ntype->dt_lengths = 0;
	}

	++(oldtype->dt_refcount);

	*newtype = ntype;
	ntype->dt_format = LAM_DTHINDEXED;
	ntype->dt_commit = 0;
	ntype->dt_refcount = 1;
	ntype->dt_label = -1;
	ntype->dt_count = count;
	ntype->dt_length = 0;
	ntype->dt_stride = 0;
	ntype->dt_dtype = oldtype;
	ntype->dt_dtypes = 0;

	for (i = 0; i < count; ++i) {

		ntype->dt_disps[i] = disps[i];

		if ((ntype->dt_lengths[i] = lengths[i]) < 0) {
			free((char *) ntype->dt_disps);
			free((char *) ntype);
			return(lam_errfunc(MPI_COMM_WORLD, BLKMPITHINDEX,
						lam_mkerr(MPI_ERR_ARG, 0)));
		}
	}

	if (count > 0) {
		ntype->dt_size = -1;

		for (i = 0; i < count; ++i) {
			lam_dtblock(ntype, oldtype, lengths[i], disps[i]);
		}

		if (ntype->dt_size > 0 && ntype->dt_lower != 0) {
			ntype->dt_flags &= ~LAM_DTNOPACK;
		}

		ntype->dt_align = (ntype->dt_size > 0) ? oldtype->dt_align : 1;
		lam_dtalign(ntype);
	}
	else {
		ntype->dt_flags |= (LAM_DTNOPACK | LAM_DTNOXADJ);
		ntype->dt_nelem = 0;
		ntype->dt_size = 0;
		ntype->dt_align = 1;
		ntype->dt_upper = ntype->dt_dataup = 0;
		ntype->dt_lower = ntype->dt_datalow = 0;
	}

	lam_resetfunc(BLKMPITHINDEX);
	return(MPI_SUCCESS);
}
