/*
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN/RBD
 *
 *	$Id: tstruct.c,v 6.1.1.1 97/02/24 14:40:27 nevin Exp $
 *
 *	Function:	- create struct derived datatype
 *	Accepts:	- # blocks
 *			- block length array
 *			- block displacement array (in bytes)
 *			- block element datatype array
 *			- ptr new datatype
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>

int
MPI_Type_struct(count, lengths, disps, oldtypes, newtype)

int			count;
int			*lengths;
MPI_Aint		*disps;
MPI_Datatype		*oldtypes;
MPI_Datatype		*newtype;

{
    MPI_Datatype	ntype;			/* new datatype */
    MPI_Datatype	oldtype;		/* old datatype */
    int			i;

    lam_initerr();
    lam_setfunc(BLKMPITSTRUCT);
/*
 * Check the arguments.
 */
    if (count < 0) {
	return(lam_errfunc(MPI_COMM_WORLD,
	    BLKMPITSTRUCT, lam_mkerr(MPI_ERR_COUNT, 0)));
    }

    if ((newtype == 0) || ((count > 0) &&
		((lengths == 0) || (disps == 0) || (oldtypes == 0)))) {

	return(lam_errfunc(MPI_COMM_WORLD,
		BLKMPITSTRUCT, lam_mkerr(MPI_ERR_ARG, 0)));
    }

    for (i = 0; i < count; ++i) {

	if (oldtypes[i] == MPI_DATATYPE_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPITSTRUCT,
			lam_mkerr(MPI_ERR_TYPE, 0)));
	}

	if (lengths[i] < 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPITSTRUCT,
			lam_mkerr(MPI_ERR_ARG, 0)));
	}
    }
/*
 * Create the new datatype.
 */
    ntype = (MPI_Datatype) malloc(sizeof(struct _dtype));
    if (ntype == 0) {
	return(lam_errfunc(MPI_COMM_WORLD,
		BLKMPITSTRUCT, lam_mkerr(MPI_ERR_OTHER, errno)));
    }

    if (count > 0) {
	ntype->dt_dtypes = (MPI_Datatype *) malloc((unsigned)
	    (count * (sizeof(MPI_Datatype) + sizeof(MPI_Aint) + sizeof(int))));
	if (ntype->dt_dtypes == 0) {
	    free((char *) ntype);
	    return(lam_errfunc(MPI_COMM_WORLD, BLKMPITSTRUCT,
			lam_mkerr(MPI_ERR_OTHER, errno)));
	}

	ntype->dt_disps = (MPI_Aint *) (((char *) ntype->dt_dtypes) +
				(count * sizeof(MPI_Datatype)));
	ntype->dt_lengths = (int *) (((char *) ntype->dt_disps) +
				(count * sizeof(MPI_Aint)));
	ntype->dt_size = -1;
	ntype->dt_flags = 0;
    } else {
	ntype->dt_dtypes = 0;
	ntype->dt_disps = 0;
	ntype->dt_lengths = 0;
	ntype->dt_size = 0;
	ntype->dt_flags = (LAM_DTNOPACK | LAM_DTNOXADJ);
    }

    *newtype = ntype;
    ntype->dt_format = LAM_DTSTRUCT;
    ntype->dt_commit = 0;
    ntype->dt_refcount = 1;
    ntype->dt_label = -1;
    ntype->dt_align = 1;
    ntype->dt_upper = ntype->dt_dataup = 0;
    ntype->dt_lower = ntype->dt_datalow = 0;
    ntype->dt_nelem = 0;
    ntype->dt_count = count;
    ntype->dt_length = 0;
    ntype->dt_stride = 0;
    ntype->dt_dtype = 0;
/*
 * Compute the extent, # elements, and data size.
 */
    for (i = 0; i < count; ++i) {

	ntype->dt_disps[i] = disps[i];
	ntype->dt_lengths[i] = lengths[i];
	ntype->dt_dtypes[i] = oldtype = oldtypes[i];
	++oldtype->dt_refcount;

	if ((oldtype->dt_align > ntype->dt_align) && (lengths[i] > 0)) {
	    ntype->dt_align = oldtype->dt_align;
	}

	lam_dtblock(ntype, oldtype, lengths[i], disps[i]);
    }

    if (ntype->dt_size > 0) {
	    if (ntype->dt_lower != 0) {
		ntype->dt_flags &= ~LAM_DTNOPACK;
	    }

	    lam_dtalign(ntype);
    }

    lam_resetfunc(BLKMPITSTRUCT);
    return(MPI_SUCCESS);
}
