/*
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN/RBD
 *
 *	$Id: tvector.c,v 6.1.1.1 97/02/24 14:43:48 nevin Exp $
 *
 *	Function:	- create vector derived datatype
 *	Accepts:	- # blocks
 *			- block length
 *			- block stride
 *			- element datatype
 *			- ptr new datatype
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>

int
MPI_Type_vector(count, length, stride, oldtype, newtype)

int			count;
int			length;
int			stride;
MPI_Datatype		oldtype;
MPI_Datatype		*newtype;

{
	MPI_Datatype	ntype;			/* new datatype */
/*
 * Check the arguments.
 */
	if (oldtype == MPI_DATATYPE_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITVECTOR, lam_mkerr(MPI_ERR_TYPE, 0)));
	}

	if (count < 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITVECTOR, lam_mkerr(MPI_ERR_COUNT, 0)));
	}

	if ((length < 0) || (newtype == 0)) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITVECTOR, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Create the new datatype.
 */
	ntype = (MPI_Datatype) malloc(sizeof(struct _dtype));
	if (ntype == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITVECTOR, lam_mkerr(MPI_ERR_OTHER, errno)));
	}

	++(oldtype->dt_refcount);

	*newtype = ntype;
	ntype->dt_format = LAM_DTVECTOR;
	ntype->dt_commit = 0;
	ntype->dt_refcount = 1;
	ntype->dt_label = -1;
	ntype->dt_align = (count > 0 && length > 0) ? oldtype->dt_align : 1;
	ntype->dt_count = count;
	ntype->dt_length = length;
	ntype->dt_stride = stride;
	ntype->dt_dtype = oldtype;
	ntype->dt_lengths = 0;
	ntype->dt_disps = 0;
	ntype->dt_dtypes = 0;

	if (count > 0) {
		ntype->dt_size = -1;
		lam_dtblock(ntype, oldtype, length, 0);

		if (count > 1 && stride != 1) {
			ntype->dt_flags &= ~LAM_DTNOPACK;
		}

		ntype->dt_nelem *= count;
		ntype->dt_size *= count;

		stride *= (oldtype->dt_upper - oldtype->dt_lower) * (count - 1);

		if (stride < 0) {
			ntype->dt_datalow += stride;
			ntype->dt_lower += stride;
		} else {
			ntype->dt_dataup += stride;
			ntype->dt_upper += stride;
		}

		lam_dtalign(ntype);
	}
	else {
		ntype->dt_flags = (LAM_DTNOPACK | LAM_DTNOXADJ);
		ntype->dt_nelem = 0;
		ntype->dt_size = 0;
		ntype->dt_upper = ntype->dt_dataup = 0;
		ntype->dt_lower = ntype->dt_datalow = 0;
	}

	lam_resetfunc(BLKMPITVECTOR);
	return(MPI_SUCCESS);
}
