/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD/GDB
 *
 *	$Id: waitsome.c,v 6.1 96/11/23 22:54:57 nevin Rel $
 *
 *	Function:	- wait for at least one request to finish
 *	Accepts:	- # of requests
 *			- array of requests
 *			- # completed requests (returned)
 *			- array of indices (returned)
 *			- array of status (returned)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <string.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <mpitrace.h>
#include <rpisys.h>

/*
 * external functions
 */
extern void		lam_emptystat();
extern void		lam_initerr();
extern void		lam_resetfunc();
extern void		lam_setfunc();
extern void		lam_tr_wrapend();
extern int		lam_tr_wrapstart();
extern int		lam_errfunc();
extern int		lam_mkerr();


int
MPI_Waitsome(count, reqs, ndone, indices, stats)

int			count;
MPI_Request		*reqs;
int			*ndone;
int			*indices;
MPI_Status		*stats;

{
	int		i;			/* favourite index */
	int		err;			/* error code */
	int		done;			/* test return flag */
	int		first;			/* first request ready */
	int		fl_err;			/* error ocurred? */
	int		fl_trace;		/* do tracing? */
	MPI_Status	firststat;		/* status of first request */
	MPI_Status	*p;			/* favourite pointer */

	lam_setfunc(BLKMPIWAITSOME);

	if (count < 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIWAITSOME,
				lam_mkerr(MPI_ERR_COUNT, 0)));
	}

	if ((count > 0) && ((reqs == 0) || (indices == 0) || (stats == 0))) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIWAITSOME,
				lam_mkerr(MPI_ERR_ARG, 0)));
	}

	if (ndone == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIWAITSOME,
				lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Generate a start wrapper trace.
 */
	fl_trace = ((_kio.ki_rtf & RTF_TRON) == RTF_TRON);

	if (fl_trace) {
		lam_tr_wrapstart(BLKMPIWAITSOME);
	}
/*
 * Loop initializing all status members.
 */
	for (i = 0, p = stats; i < count; ++i, ++p) {
		lam_emptystat(p);
	}
/*
 * Wait till the first request is done.
 */
	err = MPI_Waitany(count, reqs, &first, &firststat);

	if (err != MPI_SUCCESS) {

		if (first == MPI_UNDEFINED) {
			return(lam_errfunc(MPI_COMM_WORLD,
					BLKMPIWAITSOME, err));
		} else {
			stats[first].MPI_ERROR = err;

			if (fl_trace) {
				lam_tr_wrapend(BLKMPIWAITSOME);
			}

			lam_resetfunc(BLKMPIWAITSOME);
			return(lam_errfunc(MPI_COMM_WORLD, BLKMPIWAITSOME,
					lam_mkerr(MPI_ERR_IN_STATUS, 0)));
		}
	    }

	if (first == MPI_UNDEFINED) {
		*ndone = first;

		if (fl_trace) {
			lam_tr_wrapend(BLKMPIWAITSOME);
		}

		lam_resetfunc(BLKMPIWAITSOME);
		return(MPI_SUCCESS);
	}
/*
 * Loop testing if any other request is done and skip inactive requests.
 * I am going to be nice and maintain the sequential order
 * in the result arrays, just as if MPI_Testsome() was used.
 */
	*ndone = 0;
	fl_err = 0;

	for (i = 0; i < count; ++i, ++reqs) {

		if (i == first) {
			++(*ndone);
			*indices++ = i;
			*stats = firststat;
			stats->MPI_ERROR = MPI_SUCCESS;
			++stats;
		}
		else if ((*reqs == MPI_REQUEST_NULL) ||
				((*reqs)->rq_state == LAM_RQSINIT)) {
			continue;
		}
		else {
			err = MPI_Test(reqs, &done, stats);

			if ((err != MPI_SUCCESS) || done) {
				++(*ndone);
				*indices++ = i;

				if (err != MPI_SUCCESS) {
					stats->MPI_ERROR = err;
					fl_err = 1;
				}

				++stats;
			}
		}
	}
/*
 * Generate an end wrapper trace.
 */
	if (fl_trace) {
		lam_tr_wrapend(BLKMPIWAITSOME);
	}

	lam_resetfunc(BLKMPIWAITSOME);

	if (fl_err) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIWAITSOME,
				lam_mkerr(MPI_ERR_IN_STATUS, 0)));
	}
	
	return(MPI_SUCCESS);
}
