/*
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB/RBD
 *
 *	$Log:	dsend.c,v $
 * Revision 6.1  96/11/23  23:56:36  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:58:05  gdburns
 * Ohio Release
 * 
 * Revision 5.2.1.1  96/01/16  12:44:38  gdburns
 * Pass all network flags to the kernel.
 * 
 * Revision 5.2  94/08/22  14:07:11  gdburns
 * Ohio Release
 * 
 * Revision 5.1.1.1  94/08/18  11:43:12  gdburns
 * upgrade for new kernel
 * 
 * Revision 5.1  94/05/18  12:52:53  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:44:08  gdburns
 * Ohio Release
 *
 *	Function:	- sends a message at the datalink sublayer
 */

#include <net.h>

int
dsend(nhead)

struct nmsg		*nhead;

{
	struct kmsg	khead;		/* kernel message descriptor */	
	int4		mynodeid;
/*
 * Set up kernel message descriptor to send the network frame header.
 */
	khead.k_event = nhead->nh_dl_event;
	khead.k_length = nhead->nh_length;
/*
 * Categorize the message.
 * We must allow LOCAL to fall through before calling the router.
 */
	mynodeid = (nhead->nh_node == LOCAL) ? LOCAL : getnodeid();

	if ((nhead->nh_dl_event == nhead->nh_event) &&
			(nhead->nh_node == mynodeid)) {
		khead.k_type = nhead->nh_type;
		khead.k_flags = KNMSG | nhead->nh_flags;
	} else {
		khead.k_type = (nhead->nh_event >= 0) ? DLUSR : DLSYS;
		khead.k_flags = KNMSG | (nhead->nh_flags & (KTRY | KTRACE));

		if (nhead->nh_flags & DDLI) {
			khead.k_type |= DLI;
			nhead->nh_flags &= ~DDLI;
		}
	}

	khead.k_msg = (char *) nhead;

	return(ksend(&khead));
}

/*
 *	dtry_send
 *
 *	Function:	- non-blocking dsend()
 *	Accepts:	- ptr to network message descriptor
 *	Returns:	- 0 or ERROR
 */
int
dtry_send(nhead)

struct nmsg		*nhead;

{
	int		ret;

	nhead->nh_flags |= KTRY;
	ret = dsend(nhead);
	nhead->nh_flags &= ~KTRY;
	return(ret);
}
