/*
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Log:	nprobe.c,v $
 * Revision 6.1  96/11/23  23:56:41  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:58:08  gdburns
 * Ohio Release
 * 
 * Revision 5.2.1.1  96/01/16  02:01:29  gdburns
 * a simple wrapper for bfiprobe()
 * 
 * Revision 5.2  94/08/22  14:07:13  gdburns
 * Ohio Release
 * 
 * Revision 5.1.1.1  94/08/18  11:43:15  gdburns
 * upgrade for new kernel
 * 
 * Revision 5.1  94/05/18  12:52:55  gdburns
 * Ohio Release
 * 
 * Revision 2.3.1.1  94/05/18  10:18:51  gdburns
 * Set nh_dl_event before sending.
 * 
 * Revision 2.3  94/04/22  12:44:09  gdburns
 * Ohio Release
 * 
 *	Function:	- checks for the existance of messages with
 *			  specific events/types on the local bufferd
 *			- cannot bypass buffers due to lack of probe
 *			  capability in the kernel
 *			- receives information on whether such a 
 *			  message exists and its characteristics
 *
 *	Accepts:	- network message
 *
 *	Returns:	- 1 if message exists, 0 if not
 *			- ERROR in case of error (-1)
 *			- entries in nhead are updated: 
 *			  type, length, flags, data[0], data[1]
 */

#include <net.h>
#include <terror.h>
#include <typical.h>

int
nprobe(pnh)

struct	nmsg		*pnh;

{
	if (pnh->nh_flags & NOBUF) {
		errno = ESERVICE;
		return(ERROR);
	}

	return(bfiprobe(pnh));
}
