/*
 *	Ohio Trollius
 *	Copyright 1993 The Ohio State University
 *	GDB
 *
 *	$Id: rflat.c,v 6.1 96/11/24 00:25:59 nevin Rel $
 * 
 *	Function:	- runtime access to the flat server
 *			- loads a buffer into a node and assigns it a tag
 *			- based on Trollius 2.0 Copyright 1990
 *			  The Ohio State University and Cornell
 *			  Research Foundation
 *
 *	Accepts:	- server's node ID
 *			- load buffer length
 *			- allocated buffer length
 *			- flat tag
 *			- buffer ptr
 */

#include <unistd.h>

#include <events.h>
#include <flatreq.h>
#include <ksignal.h>
#include <net.h>
#include <rreq.h>
#include <terror.h>
#include <typical.h>

int
rflat(nodeid, buffer, ldlength, malength, tag)

int4			nodeid;
char			*buffer;
int4			ldlength;
int4			malength;
int4			tag;

{
	struct flreq	*request;	/* flatd request structure */
	struct flreply	*reply;		/* flatd reply structure */
	struct nmsg	nhead;		/* message descriptor */
	int		mask;		/* signal mask */

	if (malength == 0) return(0);

	request = (struct flreq *) nhead.nh_data;
	reply = (struct flreply *) nhead.nh_data;

	request->flq_src_node =
		((nodeid == LOCAL) || (getrtype(nodeid) & NT_CAST)) ?
		nodeid : getnodeid();
	request->flq_src_event = -getpid();
	request->flq_req = FLQLOAD;
	request->flq_ldlength = ldlength;
	request->flq_malength = malength;
	request->flq_tag = tag;

	nhead.nh_node = nodeid;
	nhead.nh_event = EVFLATD;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_msg = 0;
	nhead.nh_length = 0;
	mask = ksigblock(sigmask(SIGUDIE) | sigmask(SIGARREST));

	if (nsend(&nhead)) {
		ksigsetmask(mask);
		return(ERROR);
	}

	nhead.nh_event = request->flq_src_event;
	
	if (nrecv(&nhead)) {
		ksigsetmask(mask);
		return(ERROR);
	}

	if (reply->flr_reply) {
		errno = reply->flr_reply;
		ksigsetmask(mask);
		return(ERROR);
	}
	else {
/*
 * Load buffer to destination node.
 */
		request->flq_src_node =
			((nodeid == LOCAL) || (getrtype(nodeid) & NT_CAST)) ?
				nodeid : getnodeid();
		request->flq_src_event = -getpid();
		request->flq_req = FLQLOAD;
		request->flq_ldlength = ldlength;
		request->flq_malength = malength;
		request->flq_tag = tag;

		nhead.nh_event = EVFLATD;
		nhead.nh_msg = buffer;
		nhead.nh_type = 0;

		while (ldlength > 0) {
			nhead.nh_length = (ldlength > MAXNMSGLEN)
						? MAXNMSGLEN : ldlength;
			if (nsend(&nhead)) {
				ksigsetmask(mask);
				return(ERROR);
			}

			ldlength -= nhead.nh_length;
			nhead.nh_msg += nhead.nh_length;
		}
	}
/*
 * Receive a reply that ensures that all data has been fully loaded.
 */
	nhead.nh_event = request->flq_src_event;
	nhead.nh_length = 0;
	nhead.nh_msg = 0;

	if (nrecv(&nhead)) {
		ksigsetmask(mask);
		return(ERROR);
	}

	ksigsetmask(mask);

	if (reply->flr_reply) {
		errno = reply->flr_reply;
		return(ERROR);
	}

	return(0);
}
