/*
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Log:	rtrstore.c,v $
 * Revision 6.1  96/11/24  00:26:20  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  14:05:44  gdburns
 * Ohio Release
 * 
 *	Function:	- stores trace data with traced
 *			- generates 1 to N store requests, each less
 *			  than MAXNMSGLEN
 *
 *	Accepts:	- target node ID (should be LOCAL)
 *			- list number
 *			- process ID
 *			- ptr to trace data buffer
 *			- buffer length
 *
 *	Returns:	- return value of nsend()
 */

#include <events.h>
#include <net.h>
#include <portable.h>
#include <trreq.h>
#include <typical.h>

int
lam_rtrstore(nodeid, lnum, pid, buffer, length)

int4			nodeid;
int4			lnum;
int4			pid;
CONST char		*buffer;
int4			length;

{
	struct nmsg	nhead;		/* network message desc. */
	struct trreq	*request;	/* traced request */

	request = (struct trreq *) nhead.nh_data;

	request->trq_req = TRQSTORE;
	request->trq_pid = pid;
	request->trq_lnum = lnum;

	nhead.nh_node = nodeid;
	nhead.nh_event = EVTRACED;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_msg = (char *) buffer;

	while (length > 0) {
		nhead.nh_length = (length > MAXNMSGLEN) ? MAXNMSGLEN : length;
		request->trq_length = nhead.nh_length;

		if (nsend(&nhead)) return(LAMERROR);

		length -= nhead.nh_length;
		buffer += nhead.nh_length;
	}

	return(0);
}
