/*
 *	Ohio Trollius
 *	Copyright 1994 The Ohio State University
 *	JRV
 *
 *	$Log:	iomap.c,v $
 * Revision 6.1  96/11/24  00:35:50  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  14:06:25  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  14:17:30  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  12:58:44  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:46:51  gdburns
 * Ohio Release
 * 
 * Revision 2.2.1.2  94/01/31  17:02:13  vaigl-j
 * Remove remapfd().
 * 
 * Revision 2.2.1.1  93/06/23  15:20:52  vaigl-j
 * Fix stupid cut-paste bug in remapfd.
 * 
 * Revision 2.2  93/05/10  16:36:38  raja
 * pre-release to 2.3
 * 
 *      Function:	- mux the basic I/O calls to either Unix or Trollius
 *	Accepts:	- a flag, then same as Unix/POSIX calls, in all cases
 *	Returns:	- same as the Unix/POSIX calls, in all cases
 */

#include <limits.h>
#include <sys/types.h>
#include <unistd.h>
#include <portable.h>
#include <tstdio.h>
#include <kio.h>

/*
 * global variables
 */
extern struct kio_t	_kio;

/*
 * local functions
 */
off_t			iomap_lseek();
int			iomap_open();
int			iomap_close();
int			iomap_read();
int			iomap_write();

/*
 *	iomap_lseek
 *
 *	Function:	- maps to lseek or rflseek, based on file flags.
 *	Accepts:	- file flag
 *			- same as Unix/POSIX
 *	Returns:	- same as Unix/POSIX
 */
off_t
iomap_lseek(flag, fd, offset, whence)

unsigned int		flag;
int			fd;
off_t			offset;
int			whence;

{
	if (flag & _TIOREMOTE) {
		return((off_t) rflseek(fd, (int4) offset, whence));
	}
	else {
		return(lseek(fd, offset, whence));
	}
}

/*
 *	iomap_open
 *
 *	Function:	- maps to open or rfopen, based on file flags
 *	Accepts:	- file flag
 *			- same as Unix/POSIX
 *	Returns:	- same as Unix/POSIX
 */
int
iomap_open(flag, fname, iomode, perm)

unsigned int		flag;
char			*fname;
int			iomode;
int			perm;

{
	if (flag & _TIOREMOTE) {
		return((int) rfopen(fname, iomode, perm));
	}
	else {
		return(open(fname, iomode, perm));
	}
}

/*
 *	iomap_close
 *
 *	Function:	- maps to close or rfclose, based on file flags
 *	Accepts:	- file flag
 *			- same as Unix/POSIX
 *	Returns:	- same as Unix/POSIX
 */
int
iomap_close(flag, fd)

unsigned int		flag;
int			fd;

{
	if (flag & _TIOREMOTE) {
		return((int) rfclose(fd));
	}
	else {
		return(close(fd));
	}
}	

/*
 *	iomap_read
 *
 *	Function:	- maps to read or rfread, based on file flags
 *	Accepts:	- file flag
 *			- same as Unix/POSIX
 *	Returns:	- same as Unix/POSIX
 */
int
iomap_read(flag, fd, buf, nbyte)

unsigned int		flag;
int			fd;
char			*buf;
int			nbyte;

{
	if (flag & _TIOREMOTE) {
		return((int) rfread(fd, buf, nbyte));
	}
	else {
		return(read(fd, buf, nbyte));
	}
}

/*
 *	iomap_write
 *
 *	Function:	- maps to write or rfwrite, based on file flags
 *	Accepts:	- file flag
 *			- same as Unix/POSIX
 *	Returns:	- same as Unix/POSIX
 */
int
iomap_write(flag, fd, buf, nbyte)

unsigned int		flag;
int			fd;
char			*buf;
int			nbyte;

{

	if (flag & _TIOREMOTE) {
		return((int) rfwrite(fd, buf, nbyte));
	}
	else {
		return(write(fd, buf, nbyte));
	}
}
