/*
 *	Ohio Trollius
 *	(public domain software)
 *
 *	$Log:	tfseek.c,v $
 * Revision 6.1  96/11/24  00:36:06  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  14:06:34  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  14:17:37  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  12:58:53  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:46:58  gdburns
 * Ohio Release
 * 
 * Revision 2.2  93/05/10  16:39:00  raja
 * pre-release to 2.3
 * 
 *	We are just putting our stamp on this for housekeeping reasons.
 */

/*
 * This file is originally from dLibs 1.2 by Dale Schumacher et al.
 * It was modified for Trollius by MB, 88/12.
 * It was modified again for portability by GDB, 91/08.
 * And yet again by JRV for LAM, 93/05.
 */

#include <tstdio.h>

/*
 * external variables
 */
extern int errno;

long
tftell(fp)
	TFILE *fp;
{
	long rv;

	tfflush(fp);
	rv = (long) iomap_lseek(fp->_flag, fp->_file, (long) 0, SEEK_CUR);
	return((rv < 0) ? ((errno = ((int) rv)), (-1)) : rv);
}

int
tfseek(fp, offset, origin)
	TFILE *fp;
	long offset;
	int origin;
{
	long rv;

	tfflush(fp);
	rv = (long) iomap_lseek(fp->_flag, fp->_file, offset, origin);
	return((rv < 0) ? ((errno = ((int) rv)), (-1)) : 0);
}

void
trewind(fp)
	TFILE *fp;
{
	long rv;

	tfflush(fp);
	rv = (long) iomap_lseek(fp->_flag, fp->_file, (long) 0, SEEK_SET);
	if(rv < 0)
		errno = ((int) rv);
	fp->_flag &= ~(_TIOEOF|_TIOERR);
}
