#!/bin/bash
# init.d -- lintian collection script

# Copyright (C) 1998 by Christian Schwarz
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, you can find it on the World Wide
# Web at http://www.gnu.org/copyleft/gpl.html, or write to the Free
# Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
# MA 02111-1307, USA.

set -e

# sanity check
if [ -f "fields/package" ]; then
    # everything is ok
    :
else
    echo "error: collection script called in wrong directory!"
    exit 2
fi

rm -rf -- init.d/

if [ -d "unpacked/etc/init.d" ]; then
    cp -a "unpacked/etc/init.d" init.d
else
    # no etc/init.d
    mkdir init.d
fi

exit 0

# -----------------------------------
