/*
** Copyright (C) 1997 The University of Melbourne.
** This file may only be copied under the terms of the GNU Library General
** Public License - see the file COPYING.LIB in the Mercury distribution.
*/

/*
** mercury_trace.h - defines the interface between
** the tracing subsystem and compiled code.
**
** The macros and the function defined in this module are intended to be
** called only from code generated by the Mercury compiler, and from
** hand-compiled code in the Mercury runtime or the Mercury standard library.
*/

#ifndef MERCURY_TRACE_H
#define MERCURY_TRACE_H

#define	MR_trace_incr_seq()	(++MR_trace_call_seqno)
#define	MR_trace_incr_depth()	(++MR_trace_call_depth)
#define	MR_trace_reset_depth(d)	do { MR_trace_call_depth = (d); } while (0)

extern	int	MR_trace_call_seqno;
extern	int	MR_trace_call_depth;

typedef	enum {
	MR_PORT_CALL, MR_PORT_EXIT, MR_PORT_FAIL,
	MR_PORT_THEN, MR_PORT_ELSE, MR_PORT_DISJ, MR_PORT_SWITCH
} MR_trace_port;

typedef	enum {
	MR_MODEL_DET, MR_MODEL_SEMI, MR_MODEL_NON
} MR_trace_code_model;

extern	void	MR_trace(
	MR_trace_port,
	MR_trace_code_model,
	int,			/* call sequence number */
	int,			/* call depth */
	const char *,		/* module name */
	const char *,		/* predicate name */
	int,			/* predicate arity */
	int);			/* mode number within predicate */

extern	void	MR_trace_path(
	MR_trace_port,
	MR_trace_code_model,
	int,			/* call sequence number */
	int,			/* call depth */
	const char *,		/* module name */
	const char *,		/* predicate name */
	int,			/* predicate arity */
	int,			/* mode number within predicate */
	const char *);		/* path to event goal within procedure */

#endif /* MERCURY_TRACE_H */
