// eg2_clt.java -- an echo client that finds its server with a stringified IOR

package UK.co.orl.omniorb;

import org.omg.CORBA.*;

class eg2_clt {
  public static void main(String[] args) {
    ORB orb = ORB.init(args, null);
    if (args.length < 1) {
      System.err.println("usage: eg2_clt <object reference>");
      System.exit(1);
    }
    try {
      java.util.Random r = new java.util.Random();
      Echo obj = EchoHelper.narrow(orb.string_to_object(args[0]));
      for (;;) {
	hello(obj);
	Thread.sleep(Math.abs(r.nextLong() % 20000));
      }
    } catch (COMM_FAILURE x) {
      System.err.println("Caught system exception COMM_FAILURE, unable to " +
			 "contact the object. (minor code = " + x.minor + ")");
    } catch (Throwable x) {
      System.err.println("Caught a system exception:");
      System.err.println(x);
    }
  }
  static void hello (Echo obj) {
    String src = "Hello!";
    String dest;

    long time_pre = System.currentTimeMillis();
    dest = obj.echoString(src);
    long time_elapsed = System.currentTimeMillis() - time_pre;
    System.err.println("I said, \"" + src + "\".  " +
		       "The Object said, \"" + dest + "\" " +
		       "(" + time_elapsed + " ms)");
  }
}
      
