// $Id: Compass.java,v 1.2 1998/01/21 17:30:36 bjh Exp $

/*
$Log: Compass.java,v $
# Revision 1.2  1998/01/21  17:30:36  bjh
# Moved into UK.co.orl.weather.
#
# Revision 1.1  1997/09/02  15:08:38  bjh
# Initial revision
#
*/

// Compass.java -- an odd kind of gauge.

package UK.co.orl.weather;

import java.awt.*;

class Compass extends Gauge {
  public Compass(String title, Color pointerColor) {
    super(0, 360, 5, 90, title, "\u00B0", pointerColor);
    startAngle=(float)Math.PI/2;
    angleRange=(float)Math.PI*2;
    numPos = (float)0.5;
  }

  protected String getLabel(float value) {
    switch ((int)value) {
    case 0: case 360: return "N";
    case 45:  return "NE";
    case 90:  return "E";
    case 135: return "SE";
    case 180: return "S";
    case 225: return "SW";
    case 270: return "W";
    case 315: return "NW";
    default:  return Integer.toString((int)value);
    }
  }
}
  
