package UK.co.orl.weather;

import java.awt.*;

public class TrianglePointer extends Pointer {
  float lengthFraction;
  public TrianglePointer() {
    this(1);
  }
  public TrianglePointer(float lengthFraction) {
    super();
    this.lengthFraction = lengthFraction;
  }
  public void paint(Graphics g, int length, float theta) {
    length = (int)(length * lengthFraction);
    Point p1 = polar(length/4, (float)(theta - 2.2));
    Point p2 = polar(length/4, (float)(theta + 2.2));
    Point p3 = polar(length, theta);
    int[] xPoints = {p1.x, p2.x, p3.x};
    int[] yPoints = {p1.y, p2.y, p3.y};
    g.fillPolygon(xPoints, yPoints, 3);
  }
}
