// testAnyServer.cc
//

#include <iostream.h>

#include <common/common.h>

#include "anyStructTest_i.h"


int main(int argc, char* argv[])
{

  CORBA::ORB_ptr orb;
  CORBA::BOA_ptr boa;

  orb = CORBA::ORB_init(argc,argv,"omniORB2");
  boa = orb->BOA_init(argc,argv,"omniORB2_BOA");

  CosNaming::Name use_name;
  
  if (argc > 1) {
    if (argc != 2) {
      cerr << "Usage: testAnyServer [<COSNaming compound name (e.g. x/y/echo.obj)>]"	
	   << endl;
    }
    try {
	use_name = string_to_name(argv[1]);
    }
    catch (...) {
      cerr << argv[1] << " is not a valid COS Naming compound name." << endl;
      return 1;
    }
  }

  anyStructTest_i* anobj = new anyStructTest_i();
  anobj->_obj_is_ready(boa);

  {
    anyStructTest_var myobj = anobj->_this();
    
    if (use_name.length()) {
      if (!bindObjectToName(orb,myobj,use_name)) {
	return 1;
      }
    }
    else {
      CORBA::String_var p = orb->object_to_string(myobj);
	cerr << (char*)p << endl;
    }
  }

   boa->impl_is_ready();

   return 1;
}
