// Testing code: implementation of attrObjRef objects
//
// interface attrObjRef {
//   attribute Object obj;
// };


#include <iostream.h>
#include <string.h>
#include <attrObjRef.hh>
#include <common/common.h>

// implementation using inheritance skeleton
class attrObjRef_i : public virtual _sk_attrObjRef {
public:
  attrObjRef_i () : pd_obj(CORBA::Object::_nil()) {}
  virtual CORBA::Object_ptr  obj ();
  virtual void obj (CORBA::Object_ptr  _value);
private:
  CORBA::Object_var pd_obj;
};

CORBA::Object_ptr
attrObjRef_i::obj ()
{
  return CORBA::Object::_duplicate(pd_obj);
}

void
attrObjRef_i::obj (CORBA::Object_ptr  _value)
{
  pd_obj = CORBA::Object::_duplicate(_value);
}

int
main(int argc, char **argv) {

  try {

    CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");
    CORBA::BOA_ptr boa = orb->BOA_init(argc,argv,"omniORB2_BOA");

    CosNaming::Name use_name;
  
    if (argc > 1) {
      if (argc != 2) {
	cerr << "Usage: attrObjRefsrv [<COSNaming compound name (e.g. x/y/echo.obj)>]"	
	     << endl;
      }
      try {
	use_name = string_to_name(argv[1]);
      }
      catch (...) {
	cerr << argv[1] << " is not a valid COS Naming compound name." << endl;
	return 1;
      }
    }

    attrObjRef_i *myobj = new attrObjRef_i();
    myobj->_obj_is_ready(boa);

    {
      attrObjRef_var myobjRef = myobj->_this();
      if (use_name.length()) {
	if (!bindObjectToName(orb,myobjRef,use_name)) {
	  return 1;
	}
      }
      else {
	CORBA::String_var p = orb->object_to_string(myobjRef);
	cerr << (char*)p << endl;
      }
    }

    boa->impl_is_ready();
  }
  catch (const omniORB::fatalException &ex) {
      cerr << "#### You have caught an omniORB2 bug, details are as follows:" << endl;
      cerr << ex.file() << " " << ex.line() << ":" << ex.errmsg() << endl; 
      cerr << "main thread exited." << endl;
      return 1;
    }
  return 0;
}
