// Testing code: implementation of Texcept objects
//
//   exception Terrmsg {
//         string msg;
//   };
//
//   interface Texcept {
//         void trigger(in boolean yes) raises(Terrmsg);
//   };

#include <iostream.h>
#include <string.h>
#include <tstexcept.hh>
#include <common/common.h>

// implementation using inheritance skeleton
class Texcept_i : public virtual _sk_Texcept {
public:
  Texcept_i() {}
  virtual void trigger(CORBA::Boolean yes) throw(Terrmsg);

};

void
Texcept_i::trigger(CORBA::Boolean yes) throw(Terrmsg) {
  if (!yes)
    return;
  else {
    throw Terrmsg("Exception raised.");
  }
}

int
main(int argc, char **argv) {

  try {

    CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");
    CORBA::BOA_ptr boa = orb->BOA_init(argc,argv,"omniORB2_BOA");

    CosNaming::Name use_name;
  
    if (argc > 1) {
      if (argc != 2) {
	cerr << "Usage: tstexceptsrv [<COSNaming compound name (e.g. x/y/echo.obj)>]"	
	     << endl;
      }
      try {
	use_name = string_to_name(argv[1]);
      }
      catch (...) {
	cerr << argv[1] << " is not a valid COS Naming compound name." << endl;
	return 1;
      }
    }

    Texcept_i *myobj = new Texcept_i();
    myobj->_obj_is_ready(boa);

    {
      Texcept_var myobjRef = myobj->_this();
      if (use_name.length()) {
	if (!bindObjectToName(orb,myobjRef,use_name)) {
	  return 1;
	}
      }
      else {
	CORBA::String_var p = orb->object_to_string(myobjRef);
	cerr << (char*)p << endl;
      }
    }

    boa->impl_is_ready();

  }
  catch (const omniORB::fatalException &ex) {
      cerr << "#### You have caught an omniORB2 bug, details are as follows:" << endl;
      cerr << ex.file() << " " << ex.line() << ":" << ex.errmsg() << endl; 
      cerr << "main thread exited." << endl;
      return 1;
    }
  return 0;
}
