// Usage: server [<echo object name> <attribute object name>]
//        Names are COSNaming compound names (e.g. x/y/test.obj)
//

#include <iostream.h>
#include <common/common.h>
#include <echo.hh>
#include <attrObjRef.hh>

CORBA::BOA_ptr boa;

omni_mutex     alock;
omni_condition cond(&alock);
CORBA::Boolean block = 1;

class Echo_i : public virtual _sk_Echo {
public:
  Echo_i() {}
  virtual ~Echo_i() { cerr << "Echo_i::~Echo_i" << endl; }
  virtual char * echoString(const char *mesg);
};

char *
Echo_i::echoString(const char *mesg) {
  char *p = CORBA::string_dup(mesg);
  return p;
}

class attrObjRef_i : public virtual _sk_attrObjRef {
public:
  attrObjRef_i () : pd_obj(CORBA::Object::_nil()) {}
  virtual CORBA::Object_ptr  obj ();
  virtual void obj (CORBA::Object_ptr  _value);
private:
  CORBA::Object_var pd_obj;
};

CORBA::Object_ptr
attrObjRef_i::obj ()
{
  return CORBA::Object::_duplicate(pd_obj);
}

void
attrObjRef_i::obj (CORBA::Object_ptr  _value)
{
  omni_mutex_lock sync(alock);
  if (!CORBA::is_nil(_value)) {
    cerr << "attrObjRef_i::obj: checking if the object exists...";
    if (_value->_non_existent()) {
      cerr << "Object does not exist" << endl;
    }
    else {
      cerr << "Object exists." << endl;
    }
  }
  pd_obj = CORBA::Object::_duplicate(_value);
  if (!CORBA::is_nil(pd_obj)) {
    block = 0;
    cond.signal();
  }
}


int
main(int argc, char **argv)
{
  CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");
  boa = orb->BOA_init(argc,argv,"omniORB2_BOA");

  CosNaming::Name echo_name;
  CosNaming::Name attr_name;

  if (argc > 1) {
    if (argc != 3) {
      cerr << "Usage: server [<echo object name> <attribute object name>]\n"
	   << "       Names are COSNaming compound names (e.g. x/y/test.obj)"
	   << endl;
      return 1;
    }
    try {
      echo_name = string_to_name(argv[1]);
      attr_name = string_to_name(argv[2]);
    }
    catch (...) {
      cerr << "Either " << argv[1] << " or " << argv[2] 
	   << " is not a valid COS Naming compound name." << endl;
      return 1;
    }
  }

  Echo_i *myobj = new Echo_i;
  myobj->_obj_is_ready(boa);

  {
    Echo_var myobjRef = myobj->_this();
    if (echo_name.length()) {
      if (!bindObjectToName(orb,myobjRef,echo_name)) {
	return 1;
      }
    }
    else {
      CORBA::String_var p = orb->object_to_string(myobjRef);
      cerr << "Echo Object " << (char*)p << endl;
    }
  }

  attrObjRef_i *myattr = new attrObjRef_i();
  myattr->_obj_is_ready(boa);

  {
    attrObjRef_var myobjRef = myattr->_this();
    if (attr_name.length()) {
      if (!bindObjectToName(orb,myobjRef,attr_name)) {
	return 1;
      }
    }
    else {
      CORBA::String_var p = orb->object_to_string(myobjRef);
      cerr << "Attribute Object " << (char*)p << endl;
    }
  }

  cerr << "Main thread calling BOA is ready..." << endl;
  boa->impl_is_ready(0,1);

  while (1) {
    {
      omni_mutex_lock sync(alock);
      cerr << "Main thread block waiting for client to set Attribute Object...."
	   << endl;
      while (block) {
	cond.wait();
      }
      block = 1;
    }
    cerr << "Main thread wakes up, sleeps for 5 seconds......" <<  endl;
    omni_thread::sleep(5);
    cerr << "Main thread: dispose Echo object.....";
    myobj->_dispose();
    cerr << endl;
    cerr << "Main thread: set Attribute Object to nil...";
    myattr->obj(CORBA::Object::_nil());
    cerr << endl;

    omni_thread::sleep(1);
    cerr << "Main thread: create a new Echo object....." << endl;;
    myobj = new Echo_i;
    myobj->_obj_is_ready(boa);
    {
      Echo_var myobjRef = myobj->_this();
      if (echo_name.length()) {
	if (!bindObjectToName(orb,myobjRef,echo_name)) {
	  return 1;
	}
      }
      else {
	CORBA::String_var p = orb->object_to_string(myobjRef);
	cerr << "Echo Object " << (char*)p << endl;
      }
    }
  }
  return 0;
}


