// Testing code for the DynEnum interface

#include <iostream.h>
#include "t_Type.hh"

#define TR(x) // x

static CORBA::ORB_ptr orb;

struct TestDataT {
  EnumT          t1;
  CORBA::Any*    t1any;

  TestDataT() {
    t1any = 0;
  }

  ~TestDataT() {
    if (t1any) delete t1any;
  }
};

void
writeErrmsg(const char* f, int l, const char* msg) {
  cerr << "Error: " << f << ", line " << l << " " << msg << endl;
}

void
initialise_testdata(TestDataT& testData)
{
  testData.t1 = C;
  testData.t1any = new CORBA::Any;
  (*testData.t1any) <<= testData.t1;
}

int
test_read(TestDataT& testData)
{
  // The tests do the following:
  //    1. Create a dynany using create_dyn_any(Any) with an any argument.
  //    2. Read back the value from the dynany directly and compare with
  //       the value that has been packed into the any argument.
  {
    try {
      cerr << "TR: ";
      CORBA::DynAny_var d = orb->create_dyn_any(*testData.t1any);
      CORBA::DynEnum_var dm = CORBA::DynEnum::_narrow(d);
      if (CORBA::is_nil(dm)) {
	writeErrmsg(__FILE__,__LINE__,"failed DynEnum::_narrow.");
	return -1;
      }
      cerr << "value_as_ulong() reading..";
      CORBA::ULong v = dm->value_as_ulong();
      TR(cerr << "[" << v << " == " << (CORBA::ULong)testData.t1 << "]");
      if (v != (CORBA::ULong)testData.t1) {
	writeErrmsg(__FILE__,__LINE__,"extracted a wrong value.");
	return -1;
      }
      cerr << "value_as_string() reading..";
      CORBA::String_var sv1 = dm->value_as_string();
      const char* sv2;
      switch (testData.t1) {
      case A:
	sv2 = "A";
	break;
      case B:
	sv2 = "B";
	break;
      case C:
	sv2 = "C";
	break;
      }
      if (strcmp(sv1,sv2) != 0) {
	writeErrmsg(__FILE__,__LINE__,"extracted a wrong value.");
	return -1;
      }
      cerr << "PASSED." << endl;
      d->destroy();
    }
    catch (...) {
      writeErrmsg(__FILE__,__LINE__,"failed.");
      return -1;
    }
  }
  return 0;
}

int
test_create_write(TestDataT& testData)
{
  // The tests do the following:
  //    1. Create a dynany using create_dyn_union.
  //    2. Insert a value into the dynany
  //    3. Read back the value from the dynany directly and compare to
  //       the inserted value.
  //    4. Convert the dynany to an any.
  //    5. Read back the value in the any by creating a dynany with the
  //       any as the initial parameter and compare to the original value.
  {
    try {
      cerr << "TCW: create enum..";
      CORBA::DynEnum_var d = orb->create_dyn_enum(_tc_EnumT);
      cerr << "value_as_ulong() writing..";
      d->value_as_ulong((CORBA::ULong)testData.t1);
      cerr << "reading back..";
      CORBA::ULong v = d->value_as_ulong();
      TR(cerr << "[" << v << " == " << (CORBA::ULong)testData.t1 << "]");
      if (v != (CORBA::ULong)testData.t1) {
	writeErrmsg(__FILE__,__LINE__,"extracted a wrong value.");
	return -1;
      }
      cerr << "to any..";
      CORBA::Any_var av = d->to_any();
      cerr << "read from any..";
      CORBA::DynAny_var d2 = orb->create_dyn_any(av);
      CORBA::DynEnum_var dm = CORBA::DynEnum::_narrow(d);
      v = dm->value_as_ulong();
      TR(cerr << "[" << v << " == " << (CORBA::ULong)testData.t1 << "]");
      if (v != (CORBA::ULong)testData.t1) {
	writeErrmsg(__FILE__,__LINE__,"extracted a wrong value.");
	return -1;
      }
      cerr << "PASSED." << endl;
      d->destroy();
      d2->destroy();

      cerr << "TCW: create enum..";
      d = orb->create_dyn_enum(_tc_EnumT);
      cerr << "value_as_string() writing..";
      const char* sv;
      switch (testData.t1) {
      case A:
	sv = "A";
	break;
      case B:
	sv = "B";
	break;
      case C:
	sv = "C";
	break;
      }
      d->value_as_string(sv);
      cerr << "reading back..";
      v = d->value_as_ulong();
      TR(cerr << "[" << v << " == " << (CORBA::ULong)testData.t1 << "]");
      if (v != (CORBA::ULong)testData.t1) {
	writeErrmsg(__FILE__,__LINE__,"extracted a wrong value.");
	return -1;
      }
      cerr << "to any..";
      av = d->to_any();
      cerr << "read from any..";
      d2 = orb->create_dyn_any(av);
      dm = CORBA::DynEnum::_narrow(d);
      v = dm->value_as_ulong();
      TR(cerr << "[" << v << " == " << (CORBA::ULong)testData.t1 << "]");
      if (v != (CORBA::ULong)testData.t1) {
	writeErrmsg(__FILE__,__LINE__,"extracted a wrong value.");
	return -1;
      }
      cerr << "PASSED." << endl;
      d->destroy();
      d2->destroy();

    }
    catch (...) {
      writeErrmsg(__FILE__,__LINE__,"failed to write member.");
      return -1;
    }
  }
  return 0;
}

int
test_read_modify_write(TestDataT& testData)
{
  // The tests do the following:
  //    1. Create a dynany using create_dyn_any(Any) with an any argument.
  //    2. Modify the value using the dynany
  //    3. Read back the value from the dynany directly and compare to
  //       the modified value.
  //    4. Convert the dynany to an any.
  try {
    CORBA::DynAny_var d = orb->create_dyn_any(*testData.t1any);
    CORBA::DynEnum_var dm = CORBA::DynEnum::_narrow(d);

    cerr << "TRMW: modify enum..";
    testData.t1 = B;
    dm->value_as_ulong((CORBA::ULong)testData.t1);
    cerr << "reading back..";
    CORBA::ULong v = dm->value_as_ulong();
    TR(cerr << "[" << v << " == " << (CORBA::ULong)testData.t1 << "]");
    if (v != (CORBA::ULong)testData.t1) {
      writeErrmsg(__FILE__,__LINE__,"extracted a wrong value.");
      return -1;
    }
    cerr << "to any..";
    delete testData.t1any;
    testData.t1any = d->to_any();

    cerr << "PASSED." << endl;
    d->destroy();
  }
  catch (...) {
    writeErrmsg(__FILE__,__LINE__,"failed to modify member.");
    return -1;
  }
  cerr << "TRMW: Redo TR with the modified values..." << endl;
  return test_read(testData);
}

int
test_import_export(TestDataT& testData)
{
  // The tests exercise the import and export operations from/to any.
  {
    CORBA::DynEnum_var d = orb->create_dyn_enum(_tc_EnumT);
    cerr << "TIE: enum from_any..";
    try {
      d->from_any(*testData.t1any);
      cerr << "reading back..";
      CORBA::ULong v = d->value_as_ulong();
      TR(cerr << "[" << v << " == " << (CORBA::ULong)testData.t1 << "]");
      if (v != (CORBA::ULong)testData.t1) {
	writeErrmsg(__FILE__,__LINE__,"extracted a wrong value.");
	return -1;
      }
      cerr << "PASSED." << endl;
      d->destroy();
    }
    catch (...) {
      writeErrmsg(__FILE__,__LINE__,"failed to write member.");
      return -1;
    }
  }
  {
    try {
      CORBA::DynEnum_var d1 = orb->create_dyn_enum(_tc_EnumT);
      CORBA::DynAny_var  d2 = orb->create_dyn_any(*testData.t1any);
      CORBA::DynEnum_var d2e = CORBA::DynEnum::_narrow(d2);

      cerr << "TIE: test assign..";
      d1->assign(d2);
      CORBA::ULong v1 = d1->value_as_ulong();
      CORBA::ULong v2 = d2e->value_as_ulong();
      if (v1 != v2) {
	writeErrmsg(__FILE__,__LINE__,"assigned a wrong value.");
	return -1;
      }
      cerr << "PASSED." << endl;

      cerr << "TIE: test copy..";
      CORBA::DynAny_var d3 = d2->copy();
      CORBA::DynEnum_var d3e = CORBA::DynEnum::_narrow(d3);

      v1 = d3e->value_as_ulong();
      if (v1 != v2) {
	writeErrmsg(__FILE__,__LINE__,"copied a wrong value.");
	return -1;
      }
      cerr << "PASSED." << endl;
      d1->destroy();
      d2->destroy();
      d3->destroy();
    }
    catch(...) {
      writeErrmsg(__FILE__,__LINE__,"unexpected exception.");
      return -1;
    }
  }
  return 0;
}

int
test_iteration(TestDataT& testData)
{
  // The tests execise the iteration operations: next(), seek(), rewind(),
  // current_component() and type().
  CORBA::DynAny_var d = orb->create_dyn_any(*testData.t1any);
  cerr << "TI: ";
  try {
    cerr << "next()..";
    if (d->next() == 1) {
      writeErrmsg(__FILE__,__LINE__,"next() wrongly returns True");
      return -1;
    }
    cerr << "seek(0)..";
    if (d->seek(0) == 0) {
      writeErrmsg(__FILE__,__LINE__,"seek(0) wrongly returns False");
      return -1;
    }
    cerr << "seek(1)..";
    if (d->seek(1) == 1) {
      writeErrmsg(__FILE__,__LINE__,"seek(1) wrongly returns True");
      return -1;
    }
    cerr << "rewind()..";
    d->rewind();
    cerr << "current_component()..";
    CORBA::DynAny_var dc = d->current_component();
    if (CORBA::is_nil(dc)) {
      writeErrmsg(__FILE__,__LINE__,"current_component() returns a nil object");
      return -1;
    }
    cerr << "type()..";
    CORBA::TypeCode_var tc = dc->type();
    if (CORBA::is_nil(tc)) {
      writeErrmsg(__FILE__,__LINE__,"type() returns a nil object");
      return -1;
    }
    if (tc->kind() != CORBA::tk_enum) {
      writeErrmsg(__FILE__,__LINE__,"type() returns wrong typecode");
      return -1;
    }

    d->destroy();
    cerr << "PASSED." << endl;
  }
  catch (...) {
    writeErrmsg(__FILE__,__LINE__,"failed.");
    return -1;
  }
  return 0;
}


int
test_error_insert_invalid_value(CORBA::DynAny_ptr d,CORBA::TCKind k)
{
  try {
    if (k != CORBA::tk_boolean) {
      try {
	d->insert_boolean(1);
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::InvalidValue&) { /* expected response */ }
    }
    if (k != CORBA::tk_octet) {
      try {
	d->insert_octet(1);
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::InvalidValue&) { /* expected response */ }
    }
    if (k != CORBA::tk_char) {
      try {
	d->insert_char(1);
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::InvalidValue&) { /* expected response */ }
    }
    if (k != CORBA::tk_short) {
      try {
	d->insert_short(1);
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::InvalidValue&) { /* expected response */ }
    }
    if (k != CORBA::tk_ushort) {
      try {
	d->insert_ushort(1);
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::InvalidValue&) { /* expected response */ }
    }
    if (k != CORBA::tk_long) {
      try {
	d->insert_long(1);
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::InvalidValue&) { /* expected response */ }
    }
    if (k != CORBA::tk_ulong) {
      try {
	d->insert_ulong(1);
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::InvalidValue&) { /* expected response */ }
    }
    if (k != CORBA::tk_float) {
      try {
	d->insert_float(1);
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::InvalidValue&) { /* expected response */ }
    }
    if (k != CORBA::tk_double) {
      try {
	d->insert_double(1);
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::InvalidValue&) { /* expected response */ }
    }
    if (k != CORBA::tk_string) {
      try {
	d->insert_string("Hello");
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::InvalidValue&) { /* expected response */ }
    }
    if (k != CORBA::tk_objref) {
      try {
	d->insert_reference(CORBA::Object::_nil());
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::InvalidValue&) { /* expected response */ }
    }
    if (k != CORBA::tk_TypeCode) {
      try {
	d->insert_typecode(CORBA::TypeCode::_nil());
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::InvalidValue&) { /* expected response */ }
    }
    if (k != CORBA::tk_any) {
      try {
	CORBA::Any v;
	d->insert_any(v);
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::InvalidValue&) { /* expected response */ }
    }
  }
  catch (...) {
    writeErrmsg(__FILE__,__LINE__,"unexpected exception.");
    return -1;
  }
  return 0;
}

int
test_error_get_type_mismatch(CORBA::DynAny_ptr d,CORBA::TCKind k)
{
  try {
    if (k != CORBA::tk_boolean) {
      try {
	CORBA::Boolean v = d->get_boolean();
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::TypeMismatch&) { /* expected response */ }
    }
    if (k != CORBA::tk_octet) {
      try {
	CORBA::Octet v = d->get_octet();
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::TypeMismatch&) { /* expected response */ }
    }
    if (k != CORBA::tk_char) {
      try {
	CORBA::Char v = d->get_char();
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::TypeMismatch&) { /* expected response */ }
    }
    if (k != CORBA::tk_short) {
      try {
	CORBA::Short v = d->get_short();
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::TypeMismatch&) { /* expected response */ }
    }
    if (k != CORBA::tk_ushort) {
      try {
	CORBA::UShort v = d->get_ushort();
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::TypeMismatch&) { /* expected response */ }
    }
    if (k != CORBA::tk_long) {
      try {
	CORBA::Long v = d->get_long();
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::TypeMismatch&) { /* expected response */ }
    }
    if (k != CORBA::tk_ulong) {
      try {
	CORBA::ULong v = d->get_ulong();
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::TypeMismatch&) { /* expected response */ }
    }
    if (k != CORBA::tk_float) {
      try {
	CORBA::Float v = d->get_float();
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::TypeMismatch&) { /* expected response */ }
    }
    if (k != CORBA::tk_double) {
      try {
	CORBA::Double v = d->get_double();
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::TypeMismatch&) { /* expected response */ }
    }
    if (k != CORBA::tk_string) {
      try {
	CORBA::String_var v = d->get_string();
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::TypeMismatch&) { /* expected response */ }
    }
    if (k != CORBA::tk_objref) {
      try {
	CORBA::Object_var v = d->get_reference();
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::TypeMismatch&) { /* expected response */ }
    }
    if (k != CORBA::tk_TypeCode) {
      try {
	CORBA::TypeCode_var v = d->get_typecode();
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::TypeMismatch&) { /* expected response */ }
    }
    if (k != CORBA::tk_any) {
      try {
	CORBA::Any_var v = d->get_any();
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::TypeMismatch&) { /* expected response */ }
    }
  }
  catch (...) {
    writeErrmsg(__FILE__,__LINE__,"unexpected exception.");
    return -1;
  }
  return 0;
}

int
test_error_handling(TestDataT& testData)
{
  {
    CORBA::DynAny_var d = orb->create_dyn_enum(_tc_EnumT);
    cerr << "TEH: reject invalid value..";
    if (test_error_insert_invalid_value(d,CORBA::tk_enum) < 0)
      return -1;
    cerr << "PASSED." << endl;
    d->destroy();
  }
  {
    cerr << "TEH: reject mismatch extraction..";
    CORBA::DynAny_var d = orb->create_dyn_any(*testData.t1any);
    if (test_error_get_type_mismatch(d,CORBA::tk_enum) < 0)
      return -1;
    cerr << "PASSED." << endl;
    d->destroy();
  }
  return 0;
}

int
main(int argc, char**argv)
{
  orb = CORBA::ORB_init(argc,argv,"omniORB2");

  TestDataT t;
  initialise_testdata(t);
  if (test_read(t) < 0) {
    cerr << "Abort." << endl;
    return 1;
  }
  if (test_create_write(t) < 0) {
    cerr << "Abort." << endl;
    return 1;
  }
  if (test_read_modify_write(t) < 0) {
    cerr << "Abort." << endl;
    return 1;
  }
  if (test_import_export(t) < 0) {
    cerr << "Abort." << endl;
    return 1;
  }
  if (test_error_handling(t) < 0) {
    cerr << "Abort." << endl;
    return 1;
  }  
  if (test_iteration(t) < 0) {
    cerr << "Abort." << endl;
    return 1;
  }
  return 0;
}
