CXXSRCS = client.cc server.cc server2.cc offswitch.cc

DIR_CPPFLAGS = $(CORBA_CPPFLAGS) -I.. $(patsubst %,-I%/..,$(VPATH))

CORBA_INTERFACES = echo shutdown

COMMON_OBJS = ../common/$(patsubst %,$(LibPattern),common)
ifdef ATMos
IMPORT_LIBRARY_DIRS += .
endif

server   = $(patsubst %,$(BinPattern),server)
server2   = $(patsubst %,$(BinPattern),server2)
client    = $(patsubst %,$(BinPattern),client)
offswitch = $(patsubst %,$(BinPattern),offswitch)

all:: $(server) $(server2) $(client) $(offswitch)

clean::
	$(RM) $(server) $(server2) $(client) $(offswitch)

$(server): server.o $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND) $(COMMON_OBJS)
	@(libs="$(COMMON_OBJS) $(CORBA_LIB)"; $(CXXExecutable))

$(server2): server2.o $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND) $(COMMON_OBJS)
	@(libs="$(COMMON_OBJS) $(CORBA_LIB)"; $(CXXExecutable))

$(client): client.o $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND) $(COMMON_OBJS)
	@(libs="$(COMMON_OBJS) $(CORBA_LIB)"; $(CXXExecutable))

$(offswitch): offswitch.o $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND) $(COMMON_OBJS)
	@(libs="$(COMMON_OBJS) $(CORBA_LIB)"; $(CXXExecutable))

