/* iloop.c */
/* This routine shows how the interrupt works, when, for example, you
 * are in an infinite loop.  To try this out run it in the menu mode,
 * ie
 *
 *    iloop --menu
 *    ->
 *
 * If you enter 'N -1 =', meaning run with N=-1 (no, this isn't
 * postfix!)  then after 100 times through the loop, it will interrupt
 * itself with optAbortRun() which will bring you back to the menu.
 * If you enter any other negative N (or just a VERY large positive
 * N), then you will get into an infinite loop.  Hit ^C to get out of
 * the loop.  If the signal trapping works, then you should be
 * returned to the prompt instead of exiting the whole program.
 * 
 */
#include <stdio.h>
#include <opt.h>

long N=1;

int run()
{
    long n;
    /** if N is negative, this gives an infinite loop **/
    for (n=0; n!=N; ++n) {
        printf("Type ^C to exit\n");
        if (n==10 && N == -1) optAbortRun();
    }
    return OPT_OK;
}

main(int argc, char **argv)
{
    optreg(&N,OPT_LONG,'N',"Number of times through the loop");
    optRun(run);
    opt(&argc,&argv);
    run();
}



