/*
 * GSDV_X.C - PGS X routines
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
  
#include "pgs.h"

static PG_device
 **_PG_device_list = NULL;

static Display
 *_PG_X_display = NULL;

static int
 _PG_dsp_intr,
 _PG_tty_intr,
 _PG_n_devices,
 _PG_max_devices,
 _PG_next_char;

extern int
 _PG_nc_input;

extern jmp_buf
 io_avail;

static unsigned char
 star_bits[] = {0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x88, 0x08,
                0x90, 0x04, 0xa0, 0x02, 0x40, 0x01, 0x3e, 0x3e,
                0x40, 0x01, 0xa0, 0x02, 0x90, 0x04, 0x88, 0x08, 
                0x80, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00};

static char
 *backup_font[] = {"*-medium-r-*-12-*", "*-r-*-12-*", "*-r-*-13-*", "*-r-*-14-*"};

SC_dynamic_array
 _PG_X_point_list;

char *X_event_name[] = 
   {"Event0",
    "Event1",
    "KeyPress",
    "KeyRelease",
    "ButtonPress",
    "ButtonRelease",
    "MotionNotify",
    "EnterNotify",
    "LeaveNotify",
    "FocusIn",
    "FocusOut",
    "KeymapNotify",
    "Expose",
    "GraphicsExpose",
    "NoExpose",
    "VisibilityNotify",
    "CreateNotify",
    "DestroyNotify",
    "UnmapNotify",
    "MapNotify",
    "MapRequest",
    "ReparentNotify",
    "ConfigureNotify",
    "ConfigureRequest",
    "GravityNotify",
    "ResizeRequest",
    "CirculateNotify",
    "CirculateRequest",
    "PropertyNotify",
    "SelectionClear",
    "SelectionRequest",
    "SelectionNotify",
    "ColormapNotify",
    "ClientMessage",
    "MappingNotify"};

extern void
 SC_DECLARE(_PG_get_input, (void));

static int
 SC_DECLARE(_PG_X_get_char, (PG_device *dev)),
 SC_DECLARE(_PG_X_get_next_event, (PG_event *ev)),
 SC_DECLARE(_PG_X_open_console,
	    (char *title, char *type, int bckgr,
	     double xf, double yf, double dxf, double dyf)),
 SC_DECLARE(_PG_X_setup_font, (PG_device *dev, char *bf)),
 SC_DECLARE(_PG_X_set_font,
	    (PG_device *dev, char *face, char *style, int size));

static char
 SC_DECLARE(*_PG_get_event_core, (int check)),
 SC_DECLARE(*_PG_X_wind_fgets, 
            (char *str, int maxlen, FILE *fp));

static PG_device
 SC_DECLARE(*_PG_X_open_screen,
	    (PG_device *dev, double xf, double yf,
	     double dxf, double dyf)),
 SC_DECLARE(*_PG_X_get_event_device, (PG_event *ev));

static void
 SC_DECLARE(_PG_get_event, (void)),
 SC_DECLARE(_PG_X_query_pointer,
	    (PG_device *dev, int *px, int *py, int *pb, int *pq)),
 SC_DECLARE(_PG_X_clear_page, (PG_device *dev, int i)),
 SC_DECLARE(_PG_X_clear_window, (PG_device *dev)),
 SC_DECLARE(_PG_X_clear_viewport, (PG_device *dev)),
 SC_DECLARE(_PG_X_close_console, (byte)),
 SC_DECLARE(_PG_X_close_device, (PG_device *dev)),
 SC_DECLARE(_PG_X_expose_device, (PG_device *dev)),
 SC_DECLARE(_PG_X_finish_plot, (PG_device *dev)),
 SC_DECLARE(_PG_X_make_device_current, (PG_device *dev)),
 SC_DECLARE(_PG_X_map_to_color_table, 
            (PG_device *dev, PG_palette *pal)),
 SC_DECLARE(_PG_X_match_rgb_colors, 
            (PG_device *dev, PG_palette *pal)),
 SC_DECLARE(_PG_X_next_line, (PG_device *dev)),
 SC_DECLARE(_PG_X_puts, (char *bf)),
 SC_DECLARE(_PG_X_query_screen, 
            (PG_device *dev, int *pdx, int *pdy, int *pnc)),
 SC_DECLARE(_PG_X_release_current_device, (PG_device *dev)),
 SC_DECLARE(_PG_X_update_vs, (PG_device *dev)),
 SC_DECLARE(_PG_X_write_text, (PG_device *dev, FILE *fp, char *s)),
 SC_DECLARE(_PG_X_clear_region_NDC,
	    (PG_device *dev, double xmn, double xmx,
	     double ymn, double ymx, int pad));

#if 0

static void
 SC_DECLARE(_PG_X_expose_event, (PG_device *dev, PG_event *ev)),
 SC_DECLARE(_PG_X_update_event, (PG_device *dev, PG_event *ev)),
 SC_DECLARE(_PG_X_mouse_down_event, (PG_device *dev, PG_event *ev)),
 SC_DECLARE(_PG_X_mouse_up_event, (PG_device *dev, PG_event *ev)),
 SC_DECLARE(_PG_X_key_down_event, (PG_device *dev, PG_event *ev)),
 SC_DECLARE(_PG_X_key_up_event, (PG_device *dev, PG_event *ev)),
 SC_DECLARE(_PG_X_default_event, (PG_device *dev, PG_event *ev));

#endif

/* from the corresponding PR file */

void
 SC_DECLARE(_PG_X_draw_disjoint_polyline_2,
	    (PG_device *dev, REAL *x, REAL *y,
	     long n, int flag, int coord)),
 SC_DECLARE(_PG_X_draw_curve, 
            (PG_device *dev, PG_curve *crv, int clip)),
 SC_DECLARE(_PG_X_draw_to_abs, (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_X_draw_to_rel, (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_X_get_text_ext_NDC,
	    (PG_device *dev, char *s, REAL *px, REAL *py)),
 SC_DECLARE(_PG_X_set_clipping, (PG_device *dev, int flag)),
 SC_DECLARE(_PG_X_set_char_line, (PG_device *dev, int n)),
 SC_DECLARE(_PG_X_set_char_path, 
            (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_X_set_char_precision, (PG_device *dev, int p)),
 SC_DECLARE(_PG_X_set_char_space, (PG_device *dev, double s)),
 SC_DECLARE(_PG_X_set_char_size_NDC, 
            (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_X_set_char_up, 
            (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_X_set_fill_color, 
            (PG_device *dev, int color, int mapped)),
 SC_DECLARE(_PG_X_set_line_color, 
            (PG_device *dev, int color, int mapped)),
 SC_DECLARE(_PG_X_set_line_style, (PG_device *dev, int style)),
 SC_DECLARE(_PG_X_set_line_width, (PG_device *dev, double width)),
 SC_DECLARE(_PG_X_set_logical_op, (PG_device *dev, int lop)),
 SC_DECLARE(_PG_X_set_text_color, 
            (PG_device *dev, int color, int mapped)),
 SC_DECLARE(_PG_X_shade_poly, 
            (PG_device *dev, REAL *x, REAL *y, int n)),
 SC_DECLARE(_PG_X_fill_curve, (PG_device *dev, PG_curve *crv)),
 SC_DECLARE(_PG_X_move_gr_abs, (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_X_move_tx_abs, (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_X_move_tx_rel, (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_X_get_image,
	    (PG_device *dev, unsigned char *bf, int ix, int iy,
	     int nx, int ny)),
 SC_DECLARE(_PG_X_put_image,
	    (PG_device *dev, unsigned char *bf, int ix, int iy,
	     int nx, int ny));

PFInt
 PG_get_event_hook = _PG_X_get_next_event;

PFPPG_device
 PG_event_device_hook = _PG_X_get_event_device;

PFInt
 PG_open_console_hook = _PG_X_open_console;

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* PG_SETUP_WINDOW_DEVICE - do the device dependent device initialization
 *                        - for PG_make_device
 */

void PG_setup_window_device(d, isvis)
   PG_device *d;
   int isvis;
   {d->X_cap_style  = CapRound;
    d->X_line_style = LineSolid;
    d->X_join_style = JoinRound;
    d->X_line_width = 0;
    d->display      = NULL;
    d->font_info    = NULL;

    d->type_index   = GRAPHIC_WINDOW_DEVICE;
    d->is_visible   = isvis;

    d->query_pointer          = _PG_X_query_pointer;
    d->clear_page             = _PG_X_clear_page;
    d->clear_window           = _PG_X_clear_window;
    d->clear_viewport         = _PG_X_clear_viewport;
    d->clear_region_NDC       = _PG_X_clear_region_NDC;
    d->close_console          = _PG_X_close_console;
    d->close_device           = _PG_X_close_device;
    d->draw_dj_polyln_2       = _PG_X_draw_disjoint_polyline_2;
    d->draw_curve             = _PG_X_draw_curve;
    d->draw_to_abs            = _PG_X_draw_to_abs;
    d->draw_to_rel            = _PG_X_draw_to_rel;
    d->expose_device          = _PG_X_expose_device;
    d->finish_plot            = _PG_X_finish_plot;
    d->get_char               = _PG_X_get_char;
    d->get_image              = _PG_X_get_image;
    d->get_text_ext_NDC       = _PG_X_get_text_ext_NDC;
    d->ggets                  = (PFfgets) _PG_X_wind_fgets;
    d->gputs                  = _PG_X_puts;
    d->make_device_current    = _PG_X_make_device_current;
    d->map_to_color_table     = _PG_X_map_to_color_table;
    d->match_rgb_colors       = _PG_X_match_rgb_colors;
    d->move_gr_abs            = _PG_X_move_gr_abs;
    d->move_tx_abs            = _PG_X_move_tx_abs;
    d->move_tx_rel            = _PG_X_move_tx_rel;
    d->next_line              = _PG_X_next_line;
    d->open_screen            = _PG_X_open_screen;
    d->put_image              = _PG_X_put_image;
    d->query_screen           = _PG_X_query_screen;
    d->release_current_device = _PG_X_release_current_device;
    d->set_bound              = _PG_set_bound;
    d->set_clipping           = _PG_X_set_clipping;
    d->set_char_line          = _PG_X_set_char_line;
    d->set_char_path          = _PG_X_set_char_path;
    d->set_char_precision     = _PG_X_set_char_precision;
    d->set_char_size_NDC      = _PG_X_set_char_size_NDC;
    d->set_char_space         = _PG_X_set_char_space;
    d->set_char_up            = _PG_X_set_char_up;
    d->set_fill_color         = _PG_X_set_fill_color;
    d->set_font               = _PG_X_set_font;
    d->set_line_color         = _PG_X_set_line_color;
    d->set_line_style         = _PG_X_set_line_style;
    d->set_line_width         = _PG_X_set_line_width;
    d->set_logical_op         = _PG_X_set_logical_op;
    d->set_text_color         = _PG_X_set_text_color;
    d->shade_poly             = _PG_X_shade_poly;
    d->fill_curve             = _PG_X_fill_curve;
    d->update_vs              = _PG_X_update_vs;
    d->write_text             = _PG_X_write_text;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_X_OPEN_IMBEDDED_SCREEN - initialize a "window" on a display screen */
 
PG_device *_PG_X_open_imbedded_screen(dev, display, window, gc,
				      xf, yf, dxf, dyf)
   PG_device *dev;
   Display *display;
   Window window;
   GC gc;
   double xf, yf, dxf, dyf;
   {unsigned long bck_color, for_color, valuemask;
    unsigned int icon_width, icon_height;
    int i, Lightest, Light, Light_Gray, Dark_Gray, Dark, Darkest;
    int screen, win_x, win_y, win_width, win_height;
    int display_width, display_height;
    int n_dev_colors;
    REAL view_x_max, view_y_max, intensity;
    XWindowAttributes windowattr;
    PG_font_family *ff;

    PG_setup_markers();

/* connect to X server once only */
    dev->display = _PG_X_display = display;

    _PG_dsp_intr = PC_io_callback_fd(ConnectionNumber(_PG_X_display),
				     _PG_get_event);

/* don't let interrupts in while we're setting up the window */
    PC_catch_io_interrupts(FALSE);

    dev->type_index = GRAPHIC_WINDOW_DEVICE;
    dev->quadrant   = QUAD_FOUR;

    valuemask = 0;

    PG_query_screen(dev, &display_width, &display_height, &n_dev_colors);
    if ((display_width == 0) && (display_height == 0) &&
        (n_dev_colors == 0))
       return(NULL);

    if (dev->display == NULL)
       return(NULL);
 
    screen = DefaultScreen(dev->display);
 
/* set device pixel coordinate limits */
    dev->min_pc_x = -16383 + display_width;
    dev->max_pc_x =  16383 - display_width;
    dev->min_pc_y = -16383 + display_height;
    dev->max_pc_y =  16383 - display_height;
 
/* get the window shape in NDC */
    if ((xf == 0.0) && (yf == 0.0))
       {xf = 0.5;
        yf = 0.1;};

    if ((dxf == 0.0) && (dyf == 0.0))
       {dxf = 0.5;
        dyf = 0.5;};

    win_x = xf*display_width;
    win_y = yf*display_width;

    win_width  = dxf*display_width;
    win_height = dyf*display_width;

/* window manager hints */
    icon_width  = 16;
    icon_height = 16;

/* decide on the overall color layout and choose WHITE or BLACK background */
    dev->absolute_n_color = n_dev_colors;
    intensity = dev->max_intensity*MAXPIX;
    if (dev->background_color_white)
       {if (n_dev_colors == 2)
           {Color_Map(dev, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1);
            dev->ncolor = 2;}
        else
           {Color_Map(dev, 1, 0, 2, 3, 4, 5, 6, 7, 8, 9,
                           10, 11, 12, 13, 14, 15);
            dev->ncolor = N_COLORS;};
        Lightest   = 0;
        Light      = intensity;
        Light_Gray = 0.8*intensity;
        Dark_Gray  = 0.5*intensity;
        Dark       = 0;
        Darkest    = intensity;
        bck_color  = WhitePixel(dev->display, screen);
        for_color  = BlackPixel(dev->display, screen);}
    else
       {if (n_dev_colors == 2)
           {Color_Map(dev, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
            dev->ncolor = 2;}
        else
           {Color_Map(dev, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
                           10, 11, 12, 13, 14, 15);
            dev->ncolor = N_COLORS;};
        Lightest   = intensity;
        Light      = intensity;
        Light_Gray = 0.8*intensity;
        Dark_Gray  = 0.5*intensity;
        Dark       = 0;
        Darkest    = 0;
        bck_color  = BlackPixel(dev->display, screen);
        for_color  = WhitePixel(dev->display, screen);};

/* Note: This flag was added in order to get PG_define_region and
 *       PG_move_object to work properly. Whether the GS_XOR logical
 *       operation really has anything to do with it is uncertain.
 */
    dev->xor_parity = (bck_color == 0);

/* attach the window */
    dev->window = window;

    XSelectInput(dev->display, dev->window,
                 StructureNotifyMask |
                 ExposureMask |
/*
                 EnterWindowMask |
                 LeaveWindowMask |
*/
                 PointerMotionMask |
/*
                 ButtonMotionMask |
                 Button1MotionMask |
                 Button2MotionMask |
                 Button3MotionMask |
*/
                 KeyPressMask |
                 KeyReleaseMask |
                 ButtonPressMask |
                 ButtonReleaseMask);

/* compute the view port */
    if (dev->view_x == 0.0)
       {dev->view_x = 0.175;
        dev->view_y = 0.175;};

    if (dev->view_width == 0.0)
       dev->view_width = 0.65;

    if (dev->view_height == 0.0)
       dev->view_height = dev->view_width*dev->view_aspect;

    view_x_max = dev->view_x + dev->view_width;
    view_y_max = dev->view_y + dev->view_height;

    PG_set_viewport(dev, dev->view_x, view_x_max, dev->view_y, view_y_max);
    PG_set_window(dev, 0.0, 1.0, 0.0, 1.0);
 
/* attach graphics context */
    dev->gc = gc;

/* get window width */
    XGetWindowAttributes(dev->display, dev->window, &windowattr);
 
/* change the devices idea of window shape from NDC to pixels */
    dev->window_x      = xf*display_width;
    dev->window_y      = yf*display_width;

    dev->window_width  = windowattr.width;
    dev->window_height = windowattr.height;
 
/* set font */
    ff = PG_make_font_family(dev, "helvetica", NULL, 4,
                             "-helvetica-medium-r-",
                             "-helvetica-medium-o-",
                             "-helvetica-bold-r-",
                             "-helvetica-bold-o-");

    ff = PG_make_font_family(dev, "times", ff, 4,
                             "-times-medium-r-",
                             "-times-medium-i-",
                             "-times-bold-r-",
                             "-times-bold-i-");

    ff = PG_make_font_family(dev, "courier", ff, 4,
                             "-courier-medium-r-",
                             "-courier-medium-o-",
                             "-courier-bold-r-",
                             "-courier-bold-o-");

    dev->font_family = ff;

    PG_set_font(dev, "helvetica", "medium", 12);
    for (i = 0; dev->font_info == NULL; i++)
        {if (i > 3)
	    return(NULL);
	 _PG_X_setup_font(dev, backup_font[i]);};

/* put in the default palettes */
    PG_setup_standard_palettes(dev, 64,
			       Light, Dark,
			       Light_Gray, Dark_Gray,
			       Lightest, Darkest);

/* remember this device for event handling purposes */
    SC_REMEMBER(PG_device *, dev, _PG_device_list,
                _PG_n_devices, _PG_max_devices, 10);

/* turn interrupt handling back on */
    PC_catch_io_interrupts(TRUE);

    return(dev);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_X_OPEN_SCREEN - initialize a "window" on a display screen */
 
static PG_device *_PG_X_open_screen(dev, xf, yf, dxf, dyf)
   PG_device *dev;
   double xf, yf, dxf, dyf;
   {unsigned long bck_color, for_color, valuemask;
    unsigned int icon_width, icon_height;
    int i, Lightest, Light, Light_Gray, Dark_Gray, Dark, Darkest;
    int Xargc, screen, win_x, win_y, win_width, win_height;
    int display_width, display_height;
    int n_dev_colors;
    char **Xargv, *window_name;
    REAL view_x_max, view_y_max, intensity;
    XSetWindowAttributes setwindattr;
    XWindowAttributes windowattr;
    Pixmap icon_pixmap;
    XSizeHints size_hints;
    XGCValues values;
    XEvent report;
    GC xgc;
    PG_font_family *ff;

    PG_setup_markers();

/* don't let interrupts in while we're setting up the window */
    PC_catch_io_interrupts(FALSE);

    dev->type_index = GRAPHIC_WINDOW_DEVICE;
    dev->quadrant   = QUAD_FOUR;

    valuemask = 0;

    PG_query_screen(dev, &display_width, &display_height, &n_dev_colors);
    if ((display_width == 0) && (display_height == 0) &&
        (n_dev_colors == 0))
       return(NULL);

    if (dev->display == NULL)
       return(NULL);
 
    screen = DefaultScreen(dev->display);

/* set device pixel coordinate limits */
    dev->min_pc_x = -16383 + display_width;
    dev->max_pc_x =  16383 - display_width;
    dev->min_pc_y = -16383 + display_height;
    dev->max_pc_y =  16383 - display_height;
 
/* get the window shape in NDC */
    if ((xf == 0.0) && (yf == 0.0))
       {xf = 0.5;
        yf = 0.1;};

    if ((dxf == 0.0) && (dyf == 0.0))
       {dxf = 0.5;
        dyf = 0.5;};

    win_x = xf*display_width;
    win_y = yf*display_width;

    win_width  = dxf*display_width;
    win_height = dyf*display_width;

/* window manager hints */
    icon_width  = 16;
    icon_height = 16;

/* size hints */
    size_hints.flags      = USPosition | USSize | PMinSize;
    size_hints.x          = win_x;
    size_hints.y          = win_y;
    size_hints.width      = win_width;
    size_hints.height     = win_height;
    size_hints.min_width  = 0.25*win_width;
    size_hints.min_height = 0.25*win_height;
 
    window_name = dev->title;

    SC_INIT_DYNAMIC_ARRAY(_PG_X_point_list, XPoint, "_PG_X_OPEN_SCREEN", 20);

/* GOTCHA: if we do this it will be a memory leak
    window_name = SC_strsavef(dev->title,
                              "char*:_PG_X_OPEN_SCREEN:name");
*/
    Xargc = 0;
    Xargv = NULL;
 
/* decide on the overall color layout and choose WHITE or BLACK background */
    dev->absolute_n_color = n_dev_colors;
    intensity = dev->max_intensity*MAXPIX;
    if (dev->background_color_white)
       {if (n_dev_colors == 2)
           {Color_Map(dev, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1);
            dev->ncolor = 2;}
        else
           {Color_Map(dev, 1, 0, 2, 3, 4, 5, 6, 7, 8, 9,
                           10, 11, 12, 13, 14, 15);
            dev->ncolor = N_COLORS;};
        Lightest   = 0;
        Light      = intensity;
        Light_Gray = 0.8*intensity;
        Dark_Gray  = 0.5*intensity;
        Dark       = 0;
        Darkest    = intensity;
        bck_color  = WhitePixel(dev->display, screen);
        for_color  = BlackPixel(dev->display, screen);}
    else
       {if (n_dev_colors == 2)
           {Color_Map(dev, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
            dev->ncolor = 2;}
        else
           {Color_Map(dev, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
                           10, 11, 12, 13, 14, 15);
            dev->ncolor = N_COLORS;};
        Lightest   = intensity;
        Light      = intensity;
        Light_Gray = 0.8*intensity;
        Dark_Gray  = 0.5*intensity;
        Dark       = 0;
        Darkest    = 0;
        bck_color  = BlackPixel(dev->display, screen);
        for_color  = WhitePixel(dev->display, screen);};

/* Note: This flag was added in order to get PG_define_region and
 *       PG_move_object to work properly. Whether the GS_XOR logical
 *       operation really has anything to do with it is uncertain.
 */
    dev->xor_parity = (bck_color == 0);

/* create the window and map it to the screen */
    dev->window = XCreateSimpleWindow(dev->display,
                                      RootWindow(dev->display, screen), 
                                      win_x, win_y,
                                      win_width, win_height,
                                      dev->border_width, 
                                      for_color,
                                      bck_color);

/* turn on backing store */
    setwindattr.backing_store = WhenMapped;
    XChangeWindowAttributes(dev->display, dev->window,
                            CWBackingStore, &setwindattr);

    icon_pixmap = XCreateBitmapFromData(dev->display, 
                                        RootWindow(dev->display, screen),
                                        (char *) star_bits, 
                                        icon_width, icon_height);

    XSetStandardProperties(dev->display, dev->window, window_name, window_name, 
                           icon_pixmap, Xargv, Xargc, &size_hints);

    XSelectInput(dev->display, dev->window,
                 StructureNotifyMask |
                 ExposureMask |
/*
                 EnterWindowMask |
                 LeaveWindowMask |
*/
                 PointerMotionMask |
/*
                 ButtonMotionMask |
                 Button1MotionMask |
                 Button2MotionMask |
                 Button3MotionMask |
*/
                 KeyPressMask |
                 KeyReleaseMask |
                 ButtonPressMask |
                 ButtonReleaseMask);

    XMapWindow(dev->display, dev->window);
    XNextEvent(dev->display, &report);
 
/* compute the view port */
    if (dev->view_x == 0.0)
       {dev->view_x = 0.175;
        dev->view_y = 0.175;};

    if (dev->view_width == 0.0)
       dev->view_width = 0.65;

    if (dev->view_height == 0.0)
       dev->view_height = dev->view_width*dev->view_aspect;

    view_x_max = dev->view_x + dev->view_width;
    view_y_max = dev->view_y + dev->view_height;

    PG_set_viewport(dev, dev->view_x, view_x_max, dev->view_y, view_y_max);
    PG_set_window(dev, 0.0, 1.0, 0.0, 1.0);
 
/* create graphics context */
    xgc = XCreateGC(dev->display, dev->window, valuemask, &values);

    XSetForeground(dev->display, xgc, for_color);
    XSetBackground(dev->display, xgc, bck_color);

    dev->gc = xgc;

/* get window width */
    XGetWindowAttributes(dev->display, dev->window, &windowattr);
 
/* change the devices idea of window shape from NDC to pixels */
/*
    dev->window_x      = windowattr.x;
    dev->window_y      = windowattr.y;
*/
    dev->window_x      = xf*display_width;
    dev->window_y      = yf*display_width;
/*    dev->window_y      = yf*display_height;*/
    dev->window_width  = windowattr.width;
    dev->window_height = windowattr.height;
 
/* set font */
    ff = PG_make_font_family(dev, "helvetica", NULL, 4,
                             "-helvetica-medium-r-",
                             "-helvetica-medium-o-",
                             "-helvetica-bold-r-",
                             "-helvetica-bold-o-");

    ff = PG_make_font_family(dev, "times", ff, 4,
                             "-times-medium-r-",
                             "-times-medium-i-",
                             "-times-bold-r-",
                             "-times-bold-i-");

    ff = PG_make_font_family(dev, "courier", ff, 4,
                             "-courier-medium-r-",
                             "-courier-medium-o-",
                             "-courier-bold-r-",
                             "-courier-bold-o-");

    dev->font_family = ff;

    PG_set_font(dev, "helvetica", "medium", 12);
    for (i = 0; dev->font_info == NULL; i++)
        {if (i > 3)
	    return(NULL);
	 _PG_X_setup_font(dev, backup_font[i]);};

/* put in the default palettes */
    PG_setup_standard_palettes(dev, 64,
			       Light, Dark,
			       Light_Gray, Dark_Gray,
			       Lightest, Darkest);

/* remember this device for event handling purposes */
    SC_REMEMBER(PG_device *, dev, _PG_device_list,
                _PG_n_devices, _PG_max_devices, 10);

/* turn interrupt handling back on */
    PC_catch_io_interrupts(TRUE);

    return(dev);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_X_QUERY_SCREEN - query some physical device characteristics */

static void _PG_X_query_screen(dev, pdx, pdy, pnc)
   PG_device *dev;
   int *pdx, *pdy, *pnc;
   {int screen, n_planes;
    char *window_name;
    static int first = TRUE;

    if (first)
       {_PG_tty_intr = PC_io_callback_file(stdin, _PG_get_input);
        first        = FALSE;};

/* connect to X server once only */
    if (_PG_X_display == NULL)
       {if (strcmp(dev->name, "WINDOW") != 0)
           _PG_X_display = XOpenDisplay(dev->name);

        if (_PG_X_display == NULL)
           {window_name   = getenv("DISPLAY");
            _PG_X_display = XOpenDisplay(window_name);
            if (_PG_X_display == NULL)
               {*pdx = 0;
                *pdy = 0;
                *pnc = 0;

/* this ought to work without having to can the interrupts but debugging
 * gets to be horrendous, so ...
 */
		PG_IO_INTERRUPTS(FALSE);
                _PG_tty_intr        = FALSE;

                return;};};

        _PG_dsp_intr = PC_io_callback_fd(ConnectionNumber(_PG_X_display),
                                         _PG_get_event);};

/* printf("\nTTY: %d\nDISPLAY: %d\n", _PG_tty_intr, _PG_dsp_intr); */

    dev->display = _PG_X_display;
 
    screen   = DefaultScreen(_PG_X_display);
    n_planes = DisplayPlanes(_PG_X_display, screen);

    *pdx = DisplayWidth(_PG_X_display, screen);
    *pdy = DisplayHeight(_PG_X_display, screen);
    *pnc = 1 << n_planes;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_X_MAP_TO_COLOR_TABLE - map the PGS palette to host
 *                          - color table values
 */

static void _PG_X_map_to_color_table(dev, pal)
   PG_device *dev;
   PG_palette *pal;
   {XColor pixcolor;
    Display *disp;
    int i, status, screen, n_pal_colors;
    unsigned short *pi, last_color;
    Colormap clrmp;
    RGB_color_map *true_cm;

    n_pal_colors = pal->n_pal_colors;
    true_cm      = pal->true_colormap;

/* add two for the black and white colors at the top */
    n_pal_colors += 2;

    disp = dev->display;
    if (disp == NULL)
       return;

    pi     = FMAKE_N(unsigned short, n_pal_colors,
                     "_PG_X_MAP_TO_COLOR_TABLE:pi");
    screen = DefaultScreen(disp);
    clrmp  = DefaultColormap(disp, screen);

    pixcolor.flags = DoRed | DoGreen | DoBlue;
    pixcolor.pixel = 0;
    last_color     = 0;
    for (i = 0; i < n_pal_colors; i++)
        {pixcolor.red   = true_cm[i].red;
         pixcolor.green = true_cm[i].green;
         pixcolor.blue  = true_cm[i].blue;
   
         status = XAllocColor(disp, clrmp, &pixcolor);
         if (status != 0)
            last_color = pixcolor.pixel;

         pi[i] = last_color;};

/* this is the right thing to do when you want more colors than
 * the device supports and have to use the pseudo_cm
 *
    for (j = 0, i = 0; i < n_dev_colors; i++)
        {pixcolor.red   = true_cm[i].red;
         pixcolor.green = true_cm[i].green;
         pixcolor.blue  = true_cm[i].blue;
   
         status = XAllocColor(disp,
                              DefaultColormap(disp, screen),
                              &pixcolor);
         if (status != 0)
            last_color = pixcolor.pixel;

         pi[j++] = last_color;
         if (j >= n_pal_colors)
            break;};
*/
    pal->pixel_value = pi;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_X_MATCH_RGB_COLORS - map the RGB references in the palette to
 *                        - valid colors from the root color table
 */

static void _PG_X_match_rgb_colors(dev, pal)
   PG_device *dev;
   PG_palette *pal;
   {int i, j, npc;
    unsigned short *pi, *pir;
    RGB_color_map *true_cm;

/* add two for the black and white colors at the top */
    npc     = pal->n_pal_colors + 2;
    true_cm = pal->true_colormap;

    pi  = FMAKE_N(unsigned short, npc,
                  "_PG_X_MATCH_RGB_COLORS:pi");
    pir = dev->color_table->pixel_value;

    for (i = 0; i < npc; i++)
        {j = PG_rgb_index(dev, true_cm++);
         pi[i] = pir[j];}

    pal->pixel_value = pi;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_X_SET_FONT - set the character font */

static int _PG_X_set_font(dev, face, style, size)
   PG_device *dev;
   char *face, *style;
   int size;
   {int nfont, nstyle;
    char *font_name;
    char bf[MAXLINE];

    if (!PG_setup_font(dev, face, style, size, &font_name, &nfont, &nstyle))
       return(FALSE);

/* allow the oddball fonts */
    if (size < 4)
      sprintf(bf, "*%s*", font_name);
    else
      sprintf(bf, "*%s*-%d-*", font_name, 10 * size);

    return(_PG_X_setup_font(dev, bf));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_X_SETUP_FONT - load the named font for X if it exists */

static int _PG_X_setup_font(dev, bf)
   PG_device *dev;
   char *bf;
   {char **names;
    int i, nf, ret;
    XFontStruct *xf;
    Display *disp;

    ret  = FALSE;
    disp = dev->display;
    if (disp == NULL)
       return(ret);

    names = XListFonts(disp, bf, 1024, &nf);
    for (i = 0; i < nf; i++)
        {xf = XLoadQueryFont(disp, names[i]);
         if (xf != NULL)
            {XSetFont(disp, dev->gc, xf->fid);
             dev->font_info = xf;

             ret = TRUE;
             break;};};

    XFreeFontNames(names);

    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_X_OPEN_CONSOLE - open up a special window to be used as a console or
 *                    - terminal window for systems which can't do this for
 *                    - themselves (i.e. MacIntosh) or the SINGLE SCREEN
 *                    - devices
 */
 
static int _PG_X_open_console(title, type, bckgr, xf, yf, dxf, dyf)
   char *title, *type;
   int bckgr;
   double xf, yf, dxf, dyf;
   {int dx, dy, nc;
    double _txw0, _txh0;

    PG_setup_markers();

    PG_console_device = PG_make_device("TEXT", type, title);
    PG_query_screen(PG_console_device, &dx, &dy, &nc);
    if ((dx == 0) && (dy == 0) && (nc == 0))
       return(FALSE);

    PG_console_device->background_color_white = bckgr;

/* initialize text size info */
    _txw0 = 1.0/TXSPAN;
    _txh0 = PG_console_device->txt_ratio*_txw0;
    PG_set_char_size_NDC(PG_console_device, _txw0, _txh0);

    SC_setbuf(stdout, NULL);

    getln = (PFfgets) PG_wind_fgets;
    putln = (PFfprintf) PG_fprintf;

    SC_REMEMBER(PG_device *, PG_console_device, _PG_device_list,
                _PG_n_devices, _PG_max_devices, 10);

    return(TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_X_CLOSE_DEVICE - close a device */
 
static void _PG_X_close_device(dev)
   PG_device *dev;
   {int i, j;
    Display *disp;

    disp = dev->display;
    if (disp == NULL)
       return;

    if (dev->window)
       {XDestroyWindow(disp, dev->window);
        XFlush(disp);};

    for (i = 0; i < _PG_n_devices; i++)
        {if (dev == _PG_device_list[i])
            {_PG_n_devices--;

             for (j = i; j < _PG_n_devices; j++)
                 _PG_device_list[j] = _PG_device_list[j+1];

             _PG_device_list[_PG_n_devices] = NULL;
	     if (_PG_n_devices == 0)
	        {SFREE(_PG_device_list);
		 SC_RELEASE_DYNAMIC(_PG_X_point_list);};

             break;};};

/* clean up the device */
   _PG_rl_device(dev);

   return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_X_CLOSE_CONSOLE - close the console device */
 
static void _PG_X_close_console()
   {int i, j;

    for (i = 0; i < _PG_n_devices; i++)
        {if (PG_console_device == _PG_device_list[i])
            {_PG_n_devices--;

             for (j = i; j < _PG_n_devices; j++)
                 _PG_device_list[j] = _PG_device_list[j+1];

             _PG_device_list[_PG_n_devices] = NULL;
	     if (_PG_n_devices == 0)
	        SFREE(_PG_device_list);

             break;};};

/* clean up the device */
    _PG_rl_device(PG_console_device);

    PG_console_device = NULL;

/* connect I/O to standard functions */
    putln = io_printf_hook;
    getln = io_gets_hook;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_X_GET_NEXT_EVENT - get the next event
 *                      - return TRUE iff successful
 */

static int _PG_X_get_next_event(ev)
   PG_event *ev;
   {XNextEvent(_PG_X_display, ev);

    return(TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_X_GET_EVENT_DEVICE - return the device in which the given event
 *                        - occurred
 */

static PG_device *_PG_X_get_event_device(ev)
   PG_event *ev;
   {int i;
    Window window;
    PG_device *dev;

    window = ev->xany.window;
    for (i = 0; i < _PG_n_devices; i++)
        {dev = _PG_device_list[i];
         if (dev->window == window)
             break;};

    return((i >= _PG_n_devices) ? NULL : dev);}

/*--------------------------------------------------------------------------*/

/*                           SCREEN STATE ROUTINES                          */

/*--------------------------------------------------------------------------*/
 
/* _PG_X_CLEAR_WINDOW - clear the screen */
 
static void _PG_X_clear_window(dev)
   PG_device *dev;
   {Display *disp;

    PG_make_device_current(dev);

    disp = dev->display;
    if (disp != NULL)
       XClearWindow(disp, dev->window);
 
    PG_release_current_device(dev);

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_X_CLEAR_VIEWPORT - clear the viewport */
 
static void _PG_X_clear_viewport(dev)
   PG_device *dev;
   {

    PG_clear_region_NDC(dev, dev->sxmin, dev->sxmax,
                        dev->symin, dev->symax, 1);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_X_CLEAR_REGION_NDC - clear the rectangular region specified in NDC */
 
static void _PG_X_clear_region_NDC(dev, xmn, xmx, ymn, ymx, pad)
   PG_device *dev;
   double xmn, xmx, ymn, ymx;
   int pad;
   {int ix, iy, iw, ih;
    Display *disp;

    disp = dev->display;
    if (disp == NULL)
       return;

    PG_make_device_current(dev);

    StoP(dev, xmn, ymx, ix, iy);
    StoP(dev, xmx, ymn, iw, ih);

    ix -= pad;
    iy -= pad;
    iw -= (ix - 2*pad);
    ih -= (iy - 2*pad);
    XClearArea(disp, dev->window, ix, iy,
	       (unsigned int) iw, (unsigned int) ih, TRUE);
    
    PG_release_current_device(dev);

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_X_UPDATE_VS - update the view surface for the given device */
 
static void _PG_X_update_vs(dev)
   PG_device *dev;
   {Display *disp;

    disp = dev->display;
    if (disp == NULL)
       return;

    XFlush(disp);

    PG_release_current_device(dev);

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_X_FINISH_PLOT - do what's necessary to finish up a graphical image
 *                   - and get the device updated with the image
 *                   - after this function nothing more can be added to
 *                   - the image
 */
 
static void _PG_X_finish_plot(dev)
   PG_device *dev;
   {

    PG_make_device_current(dev);

    PG_update_vs(dev);

    PG_release_current_device(dev);

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_X_CLEAR_PAGE - clear the current page
 *                  - and go to the line i on the screen
 */
 
static void _PG_X_clear_page(dev, i)
   PG_device *dev;
   int i;
   {return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_X_EXPOSE_DEVICE - make this device the topmost one */
 
static void _PG_X_expose_device(dev)
   PG_device *dev;
   {return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_X_MAKE_DEVICE_CURRENT - make this device the current one for drawing
 *                           - purposes
 */
 
static void _PG_X_make_device_current(dev)
   PG_device *dev;
   {Window window, root, parent, child, *children;
    Display *display;
    int x, y, root_x, root_y;
    unsigned int n;
    unsigned int width, height, border_width, depth;
    REAL oxmn, oxmx, oymn, oymx;
    REAL vxmn, vxmx, vymn, vymx;

    window  = dev->window;
    display = dev->display;

    if (window)
       {PG_get_viewport_WC(dev, &oxmn, &oxmx, &oymn, &oymx);
        PG_get_viewport(dev, &vxmn, &vxmx, &vymn, &vymx);

        XQueryTree(display, window, &root, &parent, &children, &n);
        if (children != NULL) XFree((caddr_t) children);

        XGetGeometry(display, window, &root,
                     &x, &y, &width, &height, &border_width, &depth);

        dev->window_height = height;
        dev->window_width  = width;
/*	dev->border_width  = border_width; */

	XTranslateCoordinates(display, window, root,
			      0, 0, &root_x, &root_y, &child);

        dev->window_x = root_x;
        dev->window_y = root_y;

        PG_set_viewport(dev, vxmn, vxmx, vymn, vymx);
        PG_set_window(dev, oxmn, oxmx, oymn, oymx);};

    return;}
        
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_X_RELEASE_CURRENT_DEVICE - make no device current
 *                              - (SUN in its brilliance needs this)
 */
 
static void _PG_X_release_current_device(dev)
   PG_device *dev;
   {return;}
        
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_X_WRITE_TEXT - write out text to the appropriate device */
 
static void _PG_X_write_text(dev, fp, s)
   PG_device *dev;
   FILE *fp;
   char *s;
   {int ix, iy; 
    Display *disp;

    if (fp == stdscr)
       {disp = dev->display;
        if (disp == NULL)
           return;

        WtoS(dev, dev->tcurx, dev->tcury);
        StoP(dev, dev->tcurx, dev->tcury, ix, iy);

        XDrawString(disp, dev->window, dev->gc,
                    ix, iy, s, strlen(s));}
    else
       io_printf(fp, "%s", s);
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_X_NEXT_LINE - do a controlled newline */
 
static void _PG_X_next_line(dev)
   PG_device *dev;
   {putchar('\n');
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_GET_EVENT - respond to an event available interrupt */

static void _PG_get_event()
   {_PG_get_event_core(TRUE);

/* it is not obvious the keyboard input in windows should go into the
 * same buffer as keyboard input from the controlling tty
 *
    if ((_PG_input_bf != NULL) && (_PG_input_bf[0] != '\0'))
       longjmp(io_avail, ERR_FREE);
 */
    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_GET_EVENT_CORE - respond to an events
 *                    - if check is TRUE then loop while there are events
 *                    - if check is FALSE loop forever
 */

static char *_PG_get_event_core(check)
   int check;
   {int type;
    PG_text_box *b;
    PG_device *dev;
    PG_interface_object *iob;
    static PG_text_box *b0 = NULL;

    if (_PG_X_display == NULL)
       return(NULL);

    while (!check || (XEventsQueued(_PG_X_display, QueuedAfterFlush) > 0))
       {if (!PG_GET_NEXT_EVENT(PG_current_event)) 
           continue;

        dev = PG_get_event_device(PG_current_event);
        if (dev == NULL)
           continue;

/* a switch is precluded here because you need to check both the
 * event and handler at the same time so that a default handler
 * can do them all if its set up that way
 */
        type = PG_EVENT_TYPE(PG_current_event);
        if ((type == EXPOSE_EVENT) &&
            (dev->expose_event_handler.fnc != NULL))
           {PG_CALL_HANDLER(dev->expose_event_handler, dev, PG_current_event);}

        else if ((type == UPDATE_EVENT) &&
                 (dev->update_event_handler.fnc != NULL))
           {PG_CALL_HANDLER(dev->update_event_handler, dev, PG_current_event);}

        else if (type == MOUSE_DOWN_EVENT)
           {iob = PG_get_object_event(dev, &PG_current_event);
            if ((iob != NULL) && (iob->action != NULL))
               (*iob->action)(iob, &PG_current_event);
            else if (dev->mouse_down_event_handler.fnc != NULL)
               PG_CALL_HANDLER(dev->mouse_down_event_handler, dev, PG_current_event);}

        else if ((type == MOUSE_UP_EVENT) &&
                 (dev->mouse_up_event_handler.fnc != NULL))
           {PG_CALL_HANDLER(dev->mouse_up_event_handler, dev, PG_current_event);}

        else if (type == KEY_DOWN_EVENT)
           {iob = PG_get_object_event(dev, &PG_current_event);
            if ((iob != NULL) && (iob->action != NULL))
	       (*iob->action)(iob, &PG_current_event);
	    else if (dev->key_down_event_handler.fnc != NULL)
               PG_CALL_HANDLER(dev->key_down_event_handler, dev, PG_current_event);}

        else if ((type == KEY_UP_EVENT) &&
                 (dev->key_up_event_handler.fnc != NULL))
           {PG_CALL_HANDLER(dev->key_up_event_handler, dev, PG_current_event);}

        else if (type == MOTION_EVENT)
           {iob = PG_get_object_event(dev, &PG_current_event);
            if ((iob != NULL) && (strcmp(iob->type, PG_TEXT_OBJECT_S) == 0))
               {b = (PG_text_box *) iob->obj;
                if (b != b0)
		   {if (b0 != NULL)
		       _PG_draw_cursor(b0, FALSE);
		    _PG_draw_cursor(b, TRUE);
		    b0 = b;};}

            else if (b0 != NULL)
	       {_PG_draw_cursor(b0, FALSE);
		b0 = NULL;}

            else if (dev->motion_event_handler.fnc != NULL)
               PG_CALL_HANDLER(dev->motion_event_handler, dev, PG_current_event);}

        else if (dev->default_event_handler.fnc != NULL)
           PG_CALL_HANDLER(dev->default_event_handler, dev, PG_current_event);};

    return(_PG_input_bf);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_X_WIND_FGETS - get and return a string from the window environment
 *                  - start with a clean event slate, and cycle the main
 *                  - event loop until some event sets
 *                  - PG_console_device->DoneFlag
 *                  - NOTE: there is a logical problem here in that
 *                  -       sometimes you just want to use PG_wind_fgets to
 *                  -       process events
 *                  -       so if str is NULL don't hang around for
 *                  -       a string
 */
 
static char *_PG_X_wind_fgets(str, maxlen, fp)
   char *str;
   int maxlen;
   FILE *fp;
   {if (fp != stdin)
       return(io_gets(str, maxlen, fp));

    _PG_input_bf = str;
    _PG_nc_input = 0;

    if (setjmp(io_avail) == ERR_FREE)

/* turn off interrupts until the next call to _PG_X_wind_fgets */
       {PC_catch_io_interrupts(FALSE);
        return(_PG_input_bf);};

/* don't catch interrupts until the setjmp is successful */
    PC_catch_io_interrupts(TRUE);

/* if they are both on interrupts or both off interrupts
 * go let the OS block on input from either source
 */
    if (_PG_dsp_intr == _PG_tty_intr)
       {if (_PG_input_bf == NULL)
	   PC_poll_descriptors(-1);

        else
	   while (TRUE)
	      PC_poll_descriptors(-1);}

/* if only the display is on interrupts, do a blocking read on the tty */
    else if (_PG_dsp_intr)
       return(io_gets(str, maxlen, fp));

/* if only the tty is on interrupts, do a XNextEvent on the display */
    else if (_PG_tty_intr)
       return(_PG_get_event_core(FALSE));

    return(NULL);}

/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/

/* _PG_GET_EVENT_CHAR - handle key down events */

static void _PG_get_event_char(dev, ev)
   PG_device *dev;
   PG_event *ev;
   {char bf[80];
    int x, y, mod;

    PG_KEY_EVENT_INFO(dev, ev, x, y, bf, 80, mod);
    _PG_next_char = bf[0];

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_X_GET_CHAR - get one char */

static int _PG_X_get_char(dev)
   PG_device *dev;
   {PFVoid old;

    old = dev->key_down_event_handler.fnc;
    dev->key_down_event_handler.fnc = _PG_get_event_char;
    _PG_next_char = 0;

    while (!_PG_next_char)
       PC_poll_descriptors(-1);

    dev->key_down_event_handler.fnc = old;

    return(_PG_next_char);}

/*--------------------------------------------------------------------------*/

#if 0

/*------------------------------------------------------------------------*/

/* _PG_X_EXPOSE_EVENT - handle an expose event */

static void _PG_X_expose_event(dev, ev)
   PG_device *dev;
   PG_event *ev;
   {
/*
    PRINT(stdout, "\nExpose Event: %s", event[ev->type]);
*/
    return;}

/*------------------------------------------------------------------------*/
/*------------------------------------------------------------------------*/

/* _PG_X_UPDATE_EVENT - handle an update event */

static void _PG_X_update_event(dev, ev)
   PG_device *dev;
   PG_event *ev;
   {
/*
    PRINT(stdout, "\nUpdate Event: %s", event[ev->type]);
*/
    return;}

/*------------------------------------------------------------------------*/
/*------------------------------------------------------------------------*/

/* _PG_X_MOUSE_DOWN_EVENT - handle a mouse down event */

static void _PG_X_mouse_down_event(dev, ev)
   PG_device *dev;
   PG_event *ev;
   {
/*
    PRINT(stdout, "\nMouse Down Event: %s", event[ev->type]);
*/
    return;}

/*------------------------------------------------------------------------*/
/*------------------------------------------------------------------------*/

/* _PG_X_MOUSE_UP_EVENT - handle a mouse up event */

static void _PG_X_mouse_up_event(dev, ev)
   PG_device *dev;
   PG_event *ev;
   {
/*
    PRINT(stdout, "\nMouse Up Event: %s", event[ev->type]);
*/
    return;}

/*------------------------------------------------------------------------*/
/*------------------------------------------------------------------------*/

/* _PG_X_KEY_DOWN_EVENT - handle a key down event */

static void _PG_X_key_down_event(dev, ev)
   PG_device *dev;
   PG_event *ev;
   {
/*
    PRINT(stdout, "\nKey Down Event: %s", event[ev->type]);
*/
    return;}

/*------------------------------------------------------------------------*/
/*------------------------------------------------------------------------*/

/* _PG_X_KEY_UP_EVENT - handle a key up event */

static void _PG_X_key_up_event(dev, ev)
   PG_device *dev;
   PG_event *ev;
   {
/*
    PRINT(stdout, "\nKey Up Event: %s", event[ev->type]);
*/
    return;}

/*------------------------------------------------------------------------*/
/*------------------------------------------------------------------------*/

/* _PG_X_DEFAULT_EVENT - handle any event not already handled elsewhere */

static void _PG_X_default_event(dev, ev)
   PG_device *dev;
   PG_event *ev;
   {
/*
    PRINT(stdout, "\nUnknown Event: %s", event[ev->type]);
*/
    return;}

/*------------------------------------------------------------------------*/

#endif

/*------------------------------------------------------------------------*/

/* _PG_X_QUERY_POINTER - query the pointer for location and button status
 *                     - the button state is represented as follows
 *                     -   bit 0 - MOUSE_LEFT state
 *                     -   bit 1 - MOUSE_RIGHT state
 *                     -   bit 2 - MOUSE_MIDDLE state
 *                     -   bit 4 - KEY_SHIFT state
 *                     -   bit 5 - KEY_CNTL state
 *                     -   bit 6 - KEY_ALT state
 */

static void _PG_X_query_pointer(dev, px, py, pb, pq)
   PG_device *dev;
   int *px, *py, *pb, *pq;
   {Window window, root, child;
    Display *display;
    int rx, ry, btn, mod;
    unsigned int buttons;

    display = dev->display;
    window  = dev->window;

    mod = XQueryPointer(display, window, &root, &child,
                        &rx, &ry,
                        px, py, &buttons);

/* map X buttons into PGS buttons */
    btn = 0;
    btn |= (buttons & Button1Mask) ? MOUSE_LEFT   : 0;
    btn |= (buttons & Button2Mask) ? MOUSE_MIDDLE : 0;
    btn |= (buttons & Button3Mask) ? MOUSE_RIGHT  : 0;

    mod = 0;
    mod |= (buttons & ShiftMask)   ? KEY_SHIFT : 0;
    mod |= (buttons & ControlMask) ? KEY_CNTL  : 0;
    mod |= (buttons & Mod1Mask)    ? KEY_ALT   : 0;

    *pb = btn;
    *pq = mod;

    return;}

/*------------------------------------------------------------------------*/
/*------------------------------------------------------------------------*/

/* _PG_X_PUTS - put a string to the console window */

static void _PG_X_puts(bf)
   char *bf;
   {

    puts(bf);
    FLUSH_ON(stdout, bf);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
