/*
 * PCLMPS.C - parallel communications routines for PPC under LMPS
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "ppc.h"

extern void
 SC_DECLARE(INITENV, (void)),
 SC_DECLARE(WAIT_FOR_END, (void)),
 SC_DECLARE(NUM_NODES, (int *count)),
 SC_DECLARE(WHO_AM_I, (int *pid)),
 SC_DECLARE(COPY_ID, (int *from, int *to)),
 SC_DECLARE(RECEIVE, (int *pid, int *msgtype, void *msg,
		   PFInt matching_func, int *len)),
 SC_DECLARE(SRECEIVE, (int *pid, int *msgtype, void *msg, 
		    int matching_pid, int matching_msgtype, int *len)),
 SC_DECLARE(SEND, 
            (int *pid, int *msgtype, void *msg, int len, int ack)),
 SC_DECLARE(SENDR, (int *pid, int *msgtype, void *msg, int len)),
 SC_DECLARE(BROADCAST, (int *pid, int msgtyp, void *msg, int *len));

extern int
 SC_DECLARE(RECVNW, (int *pid, int *msgtype, void *msg, 
		  PFInt matching_func, int *len)),
 SC_DECLARE(SRECVNW, (int *pid, int *msgtype, void *msg, 
		   int matching_pid, int matching_msgtype, int *len));

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PC_OPEN_GROUP - open a copy of the named executable on each available
 *               - node
 */

PC_open_group(name, mode, pn, nl)
   char *name, *mode;
   int *pn;
   PROCESS *nl;
   {int i, n, mytid;

    return(TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PC_OPEN_MEMBER - open a copy of the named executable on each available
 *                - node
 */

PROCESS *PC_open_member(pnn)
   int *pnn;
   {PROCESS *pp;

    pp = FMAKE(PROCESS, "PC_OPEN_MEMBER:pp");

    INITENV();  
    NUM_NODES(pnn);
    WHO_AM_I(&(pp->acpu));

    return(pp);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PC_OUT - write data out to the filtered list of nodes
 *        - this does a message passing system's SEND command
 *        - or a LINDA-like PUT
 */

PC_out(bf, type, ni, pp, filt)
   byte *bf;
   char *type;
   size_t ni;
   PROCESS *pp;
   int *filt;
   {int i, j, ityp, dn, did, nb, t, more, *p;
    int type_index, default_node, default_id, host_node;
    int *nl, *pnl, *pl, *ppl, nn, np;
    int block_state;

    type_index   = 0;
    default_node = -1;
    default_id   = -1;
    host_node    = -1;
    block_state  = TRUE;

    ityp = 0;
    nl   = NULL;
    pl   = NULL;
    if (filt != NULL)
       {p = filt;
	more = TRUE;
	while (more)
	   {switch (*p++)
	       {case PC_MATCH_TYPE :
		     ityp |= *p++;
		     ityp |= ((type_index << 16) & PC_TYPE_MASK);
		     break;

	        case PC_MATCH_TAG :
		     ityp |= (*p++ & PC_TAG_MASK);
		     break;

	        case PC_MATCH_NODE :
                     nl = p++;
                     nn = *p++;
                     p += nn;
		     break;

	        case PC_MATCH_PID :
		     pl = p;
                     np = *p++;
                     p += np;
		     break;

	        case PC_BLOCK_STATE :
                     block_state = *p++;
                     break;

	        default :
		     more = FALSE;
		     break;};};};

    nb = ni*sizeof(int);

    if (nl == NULL)
       {nn = 1;
	pnl = &default_node;}
    else
       {pnl = nl;
	nn  = *pnl++;};

    if (nn == -1)
       BROADCAST(&dn, ityp, bf, nb);
    else
       {for (i = 0; i < nn; i++)
	    {dn = *pnl++;
	     if (dn == PC_GROUP_LEADER)
	        dn = host_node;

	     SEND(&dn, ityp, bf, nb, 0);

	     if (_PC_debug)
	        PRINT(stdout, "\t\t\tNode %d sent %d bytes to %d\n",
		      pp->acpu, nb, dn);};};

    return((int) ni);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PC_IN - read data in from the filtered list of nodes
 *       - this does a message passing system's RECV command
 *       - or a LINDA-like GET
 */

PC_in(bf, type, ni, pp, filt)
   byte *bf;
   char *type;
   size_t ni;
   PROCESS *pp;
   int *filt;
   {int i, n, ityp, dn, did, nb, t, more, *p;
    int oid, otyp;
    int type_index, block_state;

    ityp = 0;
    type_index  = 0;
    block_state = TRUE;
    if (filt != NULL)
       {p = filt;
	more = TRUE;
	while (more)
	   {switch (*p++)
	       {case PC_MATCH_TYPE :
		     ityp |= *p++;
		     ityp |= (type_index << 16) & PC_TYPE_MASK;
		     break;

	        case PC_MATCH_TAG :
		     ityp |= (*p++ & PC_TAG_MASK);
		     break;

	        case PC_MATCH_NODE :
	        case PC_MATCH_PID  :
		     break;

	        case PC_BLOCK_STATE :
                     block_state = *p++;
                     break;

	        default :
		     more = FALSE;
		     break;};};};

    nb = ni*sizeof(int);
    if (block_state)
       SRECEIVE(&oid, &otyp, bf, pp->acpu, ityp, nb);
    else
       SRECVNW(&oid, &otyp, bf, pp->acpu, ityp, nb);

    if (_PC_debug)
       PRINT(stdout, "Node %d got %d bytes\n", pp->acpu, nb);

    return((int) ni);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PC_SYNC_EXECUTION - synchronize the execution of the tasks */

void PC_sync_execution()
   {

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
